package kratos;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;


/**
 * <p>Title: GUI for Kratos</p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2005</p>
 *
 * <p>Company: </p>
 *
 * @author Hung Huynh, LanThuy Tran
 * @version 1.0
 */
public class KratosFrame
    extends JFrame implements ActionListener, WindowListener
{
    private JLabel label1 = new JLabel("Fasta file 1:");
    private JLabel label2 = new JLabel("Fasta file 2:");
    private JLabel infoLabel  = new JLabel("<html><br><br><br><br>");
    private JLabel statusLabel = new JLabel("Status", JLabel.LEFT);
    private JLabel matchLabel = new JLabel("DNA Sequence");
    private JLabel timeLabel = new JLabel("Time elapsed");

    private JTextField file1Textfield = new JTextField(30);
    private JTextField file2Textfield = new JTextField(30);
    private JButton browse1 = new JButton("Browse");
    private JButton browse2 = new JButton("Browse");
    private JButton runButton = new JButton("Find match");
    private JButton stopButton = new JButton("Stop");

    private JTextArea textarea = new JTextArea(10, 60);
    private JProgressBar progressBar = new JProgressBar(0, 10);

    private JFileChooser fc = new JFileChooser(".");
    private Process process;
    private KratosFrame self;

    public KratosFrame()
    {
        super("Kratos - Longest matching DNA sequence");
        self = this;
        addWindowListener(this);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        try
        {
            jbInit();
            setSize(460, 560);
        }
        catch (Exception ex)
        {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args)
    {
        try
        {
            UIManager.setLookAndFeel(
                "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex)
        {
        }
        catch (IllegalAccessException ex)
        {
        }
        catch (InstantiationException ex)
        {
        }
        catch (ClassNotFoundException ex)
        {
        }
        KratosFrame kratosframe = new KratosFrame();
        kratosframe.setVisible(true);
    }

    private JLabel empty()
    {
        return new JLabel(" ");
    }

    private void jbInit() throws Exception
    {
        // file browse panel
        JPanel pane1a = new JPanel(new FlowLayout(FlowLayout.LEFT));
        pane1a.add(label1);
        pane1a.add(file1Textfield);
        pane1a.add(browse1);

        JPanel pane1b = new JPanel(new FlowLayout(FlowLayout.LEFT));
        pane1b.add(label2);
        pane1b.add(file2Textfield);
        pane1b.add(browse2);

        JPanel pane1c = new JPanel();
        pane1c.add(stopButton);
        pane1c.add(runButton);

        JPanel pane1 = new JPanel(new GridLayout2(4, 1, 5, 5));
        pane1.setBorder(BorderFactory.createEmptyBorder(5,5,0,5));
        pane1.add(pane1a);
        pane1.add(pane1b);
        pane1.add(infoLabel);
        pane1.add(pane1c);
        infoLabel.setBorder(BorderFactory.createTitledBorder("Genomes:"));
        infoLabel.setPreferredSize(new Dimension(infoLabel.getSize().width, 162));

        // dna panel
        JPanel pane2 = new JPanel(new GridLayout2(2,1,5,5));
        pane2.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        pane2.add(matchLabel);
        pane2.add(new JScrollPane(textarea));
        textarea.setLineWrap(true);

        // status panel
        JPanel pane3 = new JPanel(new GridLayout2(1,3,5,5));
        pane3.setBorder(BorderFactory.createEtchedBorder());
        pane3.add(statusLabel);
        pane3.add(timeLabel);
        pane3.add(progressBar);

        statusLabel.setPreferredSize(new Dimension(150, statusLabel.getSize().height));
        timeLabel.setPreferredSize(new Dimension(150, statusLabel.getSize().height));

        JPanel main = (JPanel)getContentPane();
        main.setLayout(new BorderLayout());
        main.add(pane1, BorderLayout.NORTH);
        main.add(pane2, BorderLayout.CENTER);
        main.add(pane3, BorderLayout.SOUTH);

        self.getRootPane().setDefaultButton(runButton);
        browse1.addActionListener(this);
        browse2.addActionListener(this);
        runButton.addActionListener(this);
        stopButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e)
    {
        if (e.getSource() == runButton)
        {
            Thread t = new Thread()
            {
                public void run()
                {
                    doRun();
                }
            };
            t.start();
        }
        else if (e.getSource() == browse1)
        {
            if (fc.showOpenDialog(KratosFrame.this) == JFileChooser.APPROVE_OPTION)
            {
                file1Textfield.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
        else if (e.getSource() == browse2)
        {
            if (fc.showOpenDialog(KratosFrame.this) == JFileChooser.APPROVE_OPTION)
            {
                file2Textfield.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
        else if (e.getSource() == stopButton)
        {
            if (process != null)
            {
                process.destroy();
            }
        }
    }

    private void doRun()
    {
        if (process != null)
        {
            process.destroy();
            statusLabel.setText("Status");
            textarea.setText("");
            infoLabel.setText("");
        }

        SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                progressBar.setIndeterminate(true);
            }
        });

        String cmd = "Kratos ";
        cmd += "\"" + file1Textfield.getText() + "\" ";
        cmd += "\"" + file2Textfield.getText() + "\"";

        try
        {
            timerCount = 0;
            timer.start();
            statusLabel.setText("Searching...");
            process = Runtime.getRuntime().exec(cmd);

            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));

            String line;
            StringBuffer result = new StringBuffer();
            StringBuffer info = new StringBuffer("<html><font color=blue>");
            boolean bHasResult = false;
            boolean bInfo = true;
            boolean bShowInfo = false;

            while ((line = in.readLine()) != null && !err.ready())
            {
                if (line.startsWith("Searching"))
                {
                    bHasResult = true;
                    bInfo = false;
                    if (bShowInfo == false)
                    {
                        infoLabel.setText(info.toString());
                        bShowInfo = true;
                    }
                    textarea.setText(result.toString());
                    continue;
                }

                if (bInfo)
                {
                    info.append(line).append("<br>");
                }

                if (bHasResult)
                {
                    result.append(line).append("\n");
                }

            }

            timer.stop();
            SwingUtilities.invokeLater(new Runnable()
            {
                public void run()
                {
                    progressBar.setValue(10);
                    progressBar.setIndeterminate(false);
                }
            });

            if (err.ready())
            {
                statusLabel.setText("Error");
                JOptionPane.showMessageDialog(self, err.readLine(), "Error", JOptionPane.ERROR_MESSAGE);
            }
            else
            {
                textarea.setText(result.toString());
                statusLabel.setText("Done");
            }
        }
        catch (IOException ex)
        {
            ex.printStackTrace();
        }

    }

    private int timerCount = 0;
    javax.swing.Timer timer = new javax.swing.Timer(1000, new ActionListener()
    {
        public void actionPerformed(ActionEvent e)
        {
            timerCount++;
            int min = timerCount / 60;
            int sec = timerCount % 60;
            timeLabel.setText("Time: " + min +"m:"+ sec + "s");

        }
    });

    public void windowOpened(WindowEvent e){}
    public void windowIconified(WindowEvent e){}
    public void windowDeiconified(WindowEvent e){}
    public void windowDeactivated(WindowEvent e){}
    public void windowActivated(WindowEvent e){}
    public void windowClosed(WindowEvent e){}
    public void windowClosing(WindowEvent e)
    {
        if (process != null)
        {
            process.destroy();
        }
    }


}
