//---------------------------------------------------------------------------
// FastaFile.cpp
//---------------------------------------------------------------------------
#include "FastaFile.h"
#include <cstdio>
#include <iostream>
#include <string.h>
#include <algorithm>
using namespace std;

void FastaFile::readfile(char* filename)
{
    fileName = filename;
    // strip path
    for (int i = strlen(filename); i >= 0; i--)
    {
        if (filename[i] == '/' || filename[i] == '\\')
        {
            fileName = &filename[i+1];
            break;
        }
    }

    FILE *in = fopen(filename, "rt");

    if (!in)
    {
        cerr << "File not found: " << filename << endl;
        exit(1);
    }

    // find file size
    fseek(in, 0, SEEK_END);
    long filesize = ftell(in);
    rewind(in);

    // read first line
    firstLine = new char[300];
    fgets(firstLine, 299, in);
    firstLine[strlen(firstLine)-1] = 0; // remove newline character

    // calculate sequence length
    long curPos = ftell(in);
    sequenceLength = (int)(filesize - curPos);
    forward = new char[sequenceLength+1];
    reverse = new char[sequenceLength+1];

    if (forward == NULL || reverse == NULL)
    {
        cerr << "FastaFile.cpp: Out of memory for sequence" << endl;
        exit(1);
    }
    /**(sequence+sequenceLength) = 0;
    *(reverse+sequenceLength) = 0;*/


    // read sequence and record nucleotide histogram
    nuHist.A = nuHist.C = nuHist.T = nuHist.G = 0;
    char c;
    char *ptrForward = forward;
    char *ptrReverse = reverse;
    int count = 0;
    while (true)
    {
        c = fgetc(in);

        if (feof(in)) break;

        if (c == 'A' || c == 'T' || c == 'G' || c == 'C')
            count++;

        switch(c)
        {
        case 'a':
        case 'A':
            nuHist.A++;
            *ptrForward = c;
            ptrForward++;
            *ptrReverse = 'T';
            ptrReverse++;
            break;

        case 'c':
        case 'C':
            nuHist.C++;
            *ptrForward = c;
            ptrForward++;
            *ptrReverse = 'G';
            ptrReverse++;
            break;

        case 't':
        case 'T':
            nuHist.T++;
            *ptrForward = c;
            ptrForward++;
            *ptrReverse = 'A';
            ptrReverse++;
            break;

        case 'g':
        case 'G':
            nuHist.G++;
            *ptrForward = c;
            ptrForward++;
            *ptrReverse = 'C';
            ptrReverse++;
            break;
        }
    }

    reverse[count] = '\0';
    forward[count] = '\0';

    sequenceLength = count;

    // reverse the complements
    std::reverse(reverse, reverse+sequenceLength);

    fclose(in);
}

