/*
 * Decompiled with CFR 0.152.
 */
package kratos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import kratos.GridLayout2;

public class KratosFrame
extends JFrame
implements ActionListener,
WindowListener {
    private JLabel label1 = new JLabel("Fasta file 1:");
    private JLabel label2 = new JLabel("Fasta file 2:");
    private JLabel infoLabel = new JLabel("<html><br><br><br><br>");
    private JLabel statusLabel = new JLabel("Status", 2);
    private JLabel matchLabel = new JLabel("DNA Sequence");
    private JLabel timeLabel = new JLabel("Time elapsed");
    private JTextField file1Textfield = new JTextField(30);
    private JTextField file2Textfield = new JTextField(30);
    private JButton browse1 = new JButton("Browse");
    private JButton browse2 = new JButton("Browse");
    private JButton runButton = new JButton("Find match");
    private JButton stopButton = new JButton("Stop");
    private JTextArea textarea = new JTextArea(10, 60);
    private JProgressBar progressBar = new JProgressBar(0, 10);
    private JFileChooser fc = new JFileChooser(".");
    private Process process;
    private KratosFrame self;
    private int timerCount = 0;
    Timer timer = new Timer(1000, new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            KratosFrame.this.timerCount++;
            int min = KratosFrame.this.timerCount / 60;
            int sec = KratosFrame.this.timerCount % 60;
            KratosFrame.this.timeLabel.setText("Time: " + min + "m:" + sec + "s");
        }
    });

    public KratosFrame() {
        super("Kratos - Longest matching DNA sequence");
        this.self = this;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(3);
        try {
            this.jbInit();
            this.setSize(460, 560);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (UnsupportedLookAndFeelException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        KratosFrame kratosframe = new KratosFrame();
        kratosframe.setVisible(true);
    }

    private JLabel empty() {
        return new JLabel(" ");
    }

    private void jbInit() throws Exception {
        JPanel pane1a = new JPanel(new FlowLayout(0));
        pane1a.add(this.label1);
        pane1a.add(this.file1Textfield);
        pane1a.add(this.browse1);
        JPanel pane1b = new JPanel(new FlowLayout(0));
        pane1b.add(this.label2);
        pane1b.add(this.file2Textfield);
        pane1b.add(this.browse2);
        JPanel pane1c = new JPanel();
        pane1c.add(this.stopButton);
        pane1c.add(this.runButton);
        JPanel pane1 = new JPanel(new GridLayout2(4, 1, 5, 5));
        pane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        pane1.add(pane1a);
        pane1.add(pane1b);
        pane1.add(this.infoLabel);
        pane1.add(pane1c);
        this.infoLabel.setBorder(BorderFactory.createTitledBorder("Genomes:"));
        this.infoLabel.setPreferredSize(new Dimension(this.infoLabel.getSize().width, 162));
        JPanel pane2 = new JPanel(new GridLayout2(2, 1, 5, 5));
        pane2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane2.add(this.matchLabel);
        pane2.add(new JScrollPane(this.textarea));
        this.textarea.setLineWrap(true);
        JPanel pane3 = new JPanel(new GridLayout2(1, 3, 5, 5));
        pane3.setBorder(BorderFactory.createEtchedBorder());
        pane3.add(this.statusLabel);
        pane3.add(this.timeLabel);
        pane3.add(this.progressBar);
        this.statusLabel.setPreferredSize(new Dimension(150, this.statusLabel.getSize().height));
        this.timeLabel.setPreferredSize(new Dimension(150, this.statusLabel.getSize().height));
        JPanel main = (JPanel)this.getContentPane();
        main.setLayout(new BorderLayout());
        main.add((Component)pane1, "North");
        main.add((Component)pane2, "Center");
        main.add((Component)pane3, "South");
        this.self.getRootPane().setDefaultButton(this.runButton);
        this.browse1.addActionListener(this);
        this.browse2.addActionListener(this);
        this.runButton.addActionListener(this);
        this.stopButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.runButton) {
            Thread t = new Thread(){

                public void run() {
                    KratosFrame.this.doRun();
                }
            };
            t.start();
        } else if (e.getSource() == this.browse1) {
            if (this.fc.showOpenDialog(this) == 0) {
                this.file1Textfield.setText(this.fc.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getSource() == this.browse2) {
            if (this.fc.showOpenDialog(this) == 0) {
                this.file2Textfield.setText(this.fc.getSelectedFile().getAbsolutePath());
            }
        } else if (e.getSource() == this.stopButton && this.process != null) {
            this.process.destroy();
        }
    }

    private void doRun() {
        if (this.process != null) {
            this.process.destroy();
            this.statusLabel.setText("Status");
            this.textarea.setText("");
            this.infoLabel.setText("");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KratosFrame.this.progressBar.setIndeterminate(true);
            }
        });
        String cmd = "Kratos ";
        cmd = cmd + "\"" + this.file1Textfield.getText() + "\" ";
        cmd = cmd + "\"" + this.file2Textfield.getText() + "\"";
        try {
            String line;
            this.timerCount = 0;
            this.timer.start();
            this.statusLabel.setText("Searching...");
            this.process = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            BufferedReader err = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            StringBuffer result = new StringBuffer();
            StringBuffer info = new StringBuffer("<html><font color=blue>");
            boolean bHasResult = false;
            boolean bInfo = true;
            boolean bShowInfo = false;
            while ((line = in.readLine()) != null && !err.ready()) {
                if (line.startsWith("Searching")) {
                    bHasResult = true;
                    bInfo = false;
                    if (!bShowInfo) {
                        this.infoLabel.setText(info.toString());
                        bShowInfo = true;
                    }
                    this.textarea.setText(result.toString());
                    continue;
                }
                if (bInfo) {
                    info.append(line).append("<br>");
                }
                if (!bHasResult) continue;
                result.append(line).append("\n");
            }
            this.timer.stop();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    KratosFrame.this.progressBar.setValue(10);
                    KratosFrame.this.progressBar.setIndeterminate(false);
                }
            });
            if (err.ready()) {
                this.statusLabel.setText("Error");
                JOptionPane.showMessageDialog(this.self, err.readLine(), "Error", 0);
            } else {
                this.textarea.setText(result.toString());
                this.statusLabel.setText("Done");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

