% plots for the poisson process
set(0,                           ...
   'defaultaxesfontsize', 20,   ...
   'defaultaxeslinewidth', 1.2, ...
   'defaultlinelinewidth', 2.0, ...
   'defaultpatchlinewidth', 0.7); 


cmykflg=0;
%if cmykflg=1, this code will make cmyk figure files
%cmykflg = 1;

t = [0:.01:10];
for j = 1:5
    f=t.^(j-1).*exp(-t)/factorial(j-1);%the poisson distribution 

    
    figure(1)
    plot(t,f,'linewidth',2)
   xlabel('\alpha t','fontsize',20)
   ylabel('p_j(t)','fontsize',20)
   hold on
end
text(0.5,0.8,'j=0','fontsize',20)
text(1.4,0.4,'j=1','fontsize',20)
text(2.2,0.31,'j=2','fontsize',20)
text(3.3,0.27,'j=3','fontsize',20)
text(6,0.18,'j=4','fontsize',20)

if(cmykflg==1)
    print('../../figs_c/chapt_1/poisson_plots','-deps','-cmyk')
end
