% plots for the quorum sensing problem
set(0,                           ...
   'defaultaxesfontsize', 20,   ...
   'defaultaxeslinewidth', 1.0, ...
   'defaultlinelinewidth', 1.2, ...
   'defaultpatchlinewidth', 0.7);

 
u=[0.01:0.01:10];

K = 1;
s0=0.1;
glist = [0.5,1,  2.5];  %list of g values

figure(1)
for j = 1:length(glist);
    g = glist(j)

f = s0 + g*u.^2./(K^2+u.^2);

p = u./f;
plot(p,u,'linewidth',2);
axis([0 5 0 4])

hold on
end

text(3,1,'\gamma = 0.5','fontsize',20)
text(1,2,'\gamma = 2.5','fontsize',20)
text(2.3,2,'\gamma = 1.0','fontsize',20)
xlabel('p','fontsize',20)
ylabel('u','fontsize',20)

hold off

   