%flocking plots
set(0,                           ...
   'defaultaxesfontsize', 20,   ...
   'defaultaxeslinewidth', 1.0, ...
   'defaultlinelinewidth', 1.2, ...
   'defaultpatchlinewidth', 0.7);

 

formatSpecF = '%5.2f\n';
u = [0.01:.01:10];
f = tanh(u)/2;
s = u./(2*f);
figure(1)
plot(s,u./s/2 + 1/2,[1,max(s)],[1/2,1/2],'--',...
    [0,1],[1/2,1/2],s,-u./s/2 + 1/2,'linewidth',2)
axis([0 2 0 1])
xlabel('\sigma','fontsize',20)
ylabel('u_+/\sigma','fontsize',20)
 
slist = [0.75,1.25,2];
splace = [0.6,1.3,2];
for j = 1:3
    s = slist(j);
    figure(2)
    plot(u,2*s*f,'linewidth',2)
    xlabel('v','fontsize',20)
    axis([0 2.5 0 2.5])
    text(1.4,splace(j), strcat('\sigma = ',sprintf(formatSpecF,s)),'fontsize',20)
    hold on
end
 

figure(2)
    plot(u, u,'--','linewidth',2)
    ylabel('2\sigma f(v), v (--)','fontsize',20)
    hold off
 
%stability critical curve

%pick a value of W*
W = 1.5;
f = tanh(W)/2;
s = W./(2*f);
Fp = sech(W)^2*s-1;

detasq = [0:0.001:0.2];
vsqbyd =  (Fp-detasq)./(1-4*f.^2./(Fp-2*detasq).^2);
 figure(3)
plot(detasq,vsqbyd, 'linewidth',2)

xlabel('D\omega^2','fontsize',20)
ylabel('v^2/D','fontsize',20)
axis([0 0.1 0 20])
text(0.07,2,'stable','fontsize',20)
text( 0.03,10,'unstable','fontsize',20)
 


figure(4)
cbyv = 2*f./(2*detasq-Fp);
plot(detasq,cbyv,detasq, ones(length(detasq),1),'--','linewidth',2)
xlabel('D\omega^2','fontsize',20)
ylabel('c/v','fontsize',20)
 


