/*
 * PIHELPBU.C  Version Feb 2003 for unix only
 *
 * Purpose: Prints out brief help information interactively.
 *          This program PIHELPBU is called by PI to give
 *          online brief help information at run time. It
 *          can be run stand-alone as well. To work with PI
 *          the EXE should be named PIHELPBU.
 *
 * To compile, assemble pihelpbu.c using unix cc.
 *
 * cc -o pihelpbu pihelpbu.c
 *
 */

#include <stdio.h>
#define size(p) (sizeof(p)/sizeof(p[0]))
static
char *hlp[]={
"  *==[Function Keys]==*==[Basic Cursor Moves]==*==========[Other Keys]=======*",
"  | Full Help      ^OH| Left    ^S    LeftArrow| Line Ahead      ^Z or ^PgDn |",
"  | Shell to OS     F2| Right   ^D   RightArrow| Line Back       ^W or ^PgUp |",
"  | Insert Line     F3| Up      ^E      UpArrow| System info             ^OO |",
"  | Delete Line     F4| Down    ^X    DownArrow| Detab mode and amount   ^OD |",
"  | Search Ahead    F5| Page up      ^R or PgUp| Word Wrap toggle        ^OW |",
"  | Search Back     F6| Page Down    ^C or PgDn| Auto Indent toggle      ^OI |",
"  | Query Replace  ^QA| Edge Left          HOME| Insert char       ^V or INS |",
"  | Record steps    F8| Edge Right          END| Set Tab and margin      ^OT |",
"  | Repeat steps    F7| Edge Bottom        ^END| Delete char right ^G or DEL |",
"  | Copy Line       F9| Edge Top          ^HOME| Delete char left  BACKSPACE |",
"  | Paste Line     F10| End of File  Enter PgDn| Newline split-line      ^ON |",
"  | Phrase copy    ^F9| Top of File  Enter PgUp| Erase to end of line    ^QT |",
"  | Phrase paste  ^F10|==[Buffers and Files]===| Setup line/box draw     ^OL |",
"  | Phrase kill    ^OZ| Buffer Ahead        ^L | Reform to margin        ^B  |",
"  | Phrase->NotePad^OP| Buffer list         ^KA| Center line            ^O,c |",
"  | SciCalc phrase^O,k| Save & Exit         ^KX| Copy line to NoteP Shift-F3 |",
"  | Word to upper ^O,U| Save & Scrap        ^KD| Move line to NoteP Shift-F4 |",
"  | Word to lower ^O,L| Save As ...         ^KW| Control codes: ^P then char |",
"  | Word capital  ^O,C| Save File (backup)  ^KS| ENTER KEY: F12 or Grey ENTER|",
"  | Switch chars ALT-T| Scrap File          ^KQ*=============================*",
"  | Switch lines ALT-L| Paste File          ^KR|[Quit Pi Editor]: ^KZ, ALT-X |",
"  | Kill word       ^T| Print File          ^KP|[Menu]:     Dark* or ESC-ESC |",
"  *===================*========================*=============================*",
"    [KEYPAD CURSOR MOVES]             [ESCAPE KEYPAD MOVES]",
"  *=======*",
"  |  Esc  |",
"  |[ENTER]|",
"  *=======*=======*======*=======*  *======*=======*======*",
"  |   7   |   8   |  9   |       |  |      |   8   | top  |",
"  |Left   |  Up   |Page  |       |  |      |search |  of  |",
"  |Edge   | Char  | up   |       |  |      |str Up | file |",
"  *=======*=======*======*=======*  *======*=======*======*",
"  |    4  |       |  6   |       |  |  4   |   5   |  6   |",
"  |  Left |       |Right |       |  |delete|       |grab  |",
"  |  char |       |char  |       |  |char  |       |char  |",
"  *=======*=======*======*=======*  *======*=======*======*",
"  |   1   |  2    |  3   |       |  |Grab  |   2   |bottom|",
"  |Right  | Down  |Page  |       |  |word  |search |  of  |",
"  |Edge   | Char  | down |ENTER  |  |token |str Dn | file |",
"  *===========*==========| KEY   |  *======*=======*======*",
"  | 0         |   .      |       |[Press ESC twice, then the key]",
"  |    Insert |Delete    |       |",
"  |    Toggle |Char Rt   |       |",
"  *===========*==========*=======*",
"",
"",
"",
"  LEFT KEYPAD       LEFT KEYPAD       LEFT KEYPAD",
"    [NORMAL]          [CTRL]           [SHIFTED]",
"*======*======*   *======*======*   *======*======*    RIGHT KEYPAD FUNCTIONS",
"|  F1  |  F2  |   |  F1  |  F2  |   |  F1  |  F2  |      PRESS [CTRL] FIRST",
"|Center|Shell |   |      |      |   |Text  |System|",
"|screen|to OS |   |      |      |   |Help  |comman|   *=======*=======*======*",
"*======*======*   *======*======*   *======*======*   |   7   |   8   |  9   |",
"|  F3  |  F4  |   |  F3  |  F4  |   |  F3  |  F4  |   |Top of |       |Line  |",
"|insert|delete|   |      |      |   |CopyTo|MoveTo|   |Screen |       | up   |",
"|line  |line  |   |      |      |   |NotePd|NotePd|   *=======*=======*======*",
"*======*======*   *======*======*   *======*======*   |    4  |       |  6   |",
"|  F4  |  F5  |   |  F4  |  F5  |   |  F4  |  F5  |   | Left  |       |Right |",
"|search|search|   |      |      |   |      |      |   | Edge  |       |Edge  |",
"|ahead |back  |   |      |      |   |      |      |   *=======*=======*======*",
"*======*======*   *======*======*   *======*======*   |   1   |  2    |  3   |",
"|  F7  |  F8  |   |  F7  |  F8  |   |  F7  |  F8  |   |Bottom |       |Line  |",
"|start |record|   |      |      |   |      |      |   |Screen |       | down |",
"|macro |macro |   |      |      |   |      |      |   *=======*=======*======*",
"*======*======*   *======*======*   *======*======*",
"|  F9  |  F10 |   |  F9  |  F10 |   |  F9  |  F10 |",
"|Paste |Copy  |   | copy |paste |   |      |      |    IBM-PC/XT/AT Keyboard",
"|line  |line  |   |phrase|phrase|   |      |      |",
"*======*======*   *======*======*   *======*======*",
"",
"                      [101 KEYBOARD FUNCTION KEYS]",
"       *======*======*======*======*======*======*======*======*======*======*",
"       |  F1  |  F2  |  F3  |  F4  |  F4  |  F5  |  F7  |  F8  |  F9  |  F10 |",
"Normal |Center|Shell |insert|delete|search|search|start |record|Copy  |Paste |",
"       |Screen|to DOS|line  |line  |ahead |back  |macro |macro |line  |line  |",
"       *======*======*======*======*======*======*======*======*======*======*",
"",
"       *======*======*======*======*======*======*======*======*======*======*",
"       |  F1  |  F2  |  F3  |  F4  |  F4  |  F5  |  F7  |  F8  |  F9  |  F10 |",
"Ctrl   |Macro |Keymap|      |      |      |      |      |      |copy  |paste |",
"       |Editor|Editor|      |      |      |      |      |      |phrase|phrase|",
"       *======*======*======*======*======*======*======*======*======*======*",
"",
"       *======*======*======*======*======*======*======*======*======*======*",
"       |  F1  |  F2  |  F3  |  F4  |  F4  |  F5  |  F7  |  F8  |  F9  |  F10 |",
"Shift  |Text  |      |CopyTo|MoveTo|      |      |      |      |      |      |",
"       |Help  |      |NotePd|NotePd|      |      |      |      |      |      |",
"       *======*======*======*======*======*======*======*======*======*======*",
"",
"",
"",
"",
"",
"",
"            [WORDSTAR LAYOUT FOR STANDARD QWERTY KEYBOARDS]",
"",
"*======*======*======*======*======*======*======*======*======*======*",
"| Q    | W    |  E   |  R   |  T   |  Y   | U    | I    |  O   |  P   |",
"|Quick |line  |up    |prev  |erase |delete|abort |tab   |Option|ctrl  |",
"|prefix|up    |arrow |screen|word  |line  |key   |right |prefix|insert|",
"*======*======*======*======*======*======*======*======*======*======*",
"  | A    | S    |  D   |  F   |  G   |  H   |  J   |   K  |  L    |",
"  |left  |left  |right |right |delete|delete|Split+|File  | switch|",
"  |word  |arrow |arrow |word  |right |left  |Return|prefix| buffer|",
"  *======*======*======*======*======*======*======*======*=======*",
"    | Z    | X    |  C   |  V   | B    | N    |  M   |",
"    |line  |down  |next  |insert|reform|insert|next  |",
"    |down  |arrow |screen|toggle|lines |line  |line  |",
"    *======*======*======*======*======*======*======",
"",
"",
" Wordstar keys are executed by holding down [ctrl], then press the key",
"                   or keys required for the sequence.",
"",
"          For more help, press four ESC keys in the editor.",
"",
"",
""
};

void clrscr()
{
 printf("\033[H\033[2J");
}

int getch(){
char s[128];
  fgets(s,127,stdin);
  return s[0];
}



int main() {
int i,j,k;
loop:
  for(k=j=0;j<size(hlp)/24;++j){
    clrscr();
    for(i=0;i<24;++i) printf("%s\n",hlp[k++]);
    printf("Press [RETURN] to continue, [Q] to quit: ");
    switch(getch()){
    case 'Q':
    case 'q':
    case 'S':
    case 's':
    case 'E':
    case 'e':
    case 3: goto quit;
    }
  }
  goto loop;
quit:
 return 0;
}
