#include <windows.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <ctype.h>

#if 0                           /* See windows.h, WIN.H */
#define VK_SUBTRACT     0x6D
#define VK_DECIMAL      0x6E
#define VK_DIVIDE       0x6F
#endif


#if 0
struct {
  int vk;
  const char *val[5];
} keytableCYGWIN[] = {
              /* NORMAL */ /* SHIFT */ /* CTRL */ /* ALT */    /* SHIFTC */
  {VK_LEFT,   {"\033[D",   "\033[D",   "\033[D",  "\033\033[D","\033[D"}},
  {VK_RIGHT,  {"\033[C",   "\033[C",   "\033[C",  "\033\033[C","\033[C"}},
  {VK_UP,     {"\033[A",   "\033[A",   "\033[A",  "\033\033[A","\033[A"}},
  {VK_DOWN,   {"\033[B",   "\033[B",   "\033[B",  "\033\033[B","\033[B"}},
  {VK_PRIOR,  {"\033[5~",  "\033[5~",  "\033[5~", "\033\033[5~","\033[5~"}},
  {VK_NEXT,   {"\033[6~",  "\033[6~",  "\033[6~", "\033\033[6~","\033[6~"}},
  {VK_HOME,   {"\033[1~",  "\033[1~",  "\033[1~", "\033\033[1~","\033[1~"}},
  {VK_END,    {"\033[4~",  "\033[4~",  "\033[4~", "\033\033[4~","\033[4~"}},
  {VK_INSERT, {"\033[2~",  "\033[2~",  "\033[2~", "\033\033[2~","\033[2~"}},
  {VK_DELETE, {"\033[3~",  "\033[3~",  "\033[3~", "\033\033[3~","\033[3~"}},
  {VK_F1,     {"\033[[A",  "\033[23~", NULL,      NULL,       NULL}},
  {VK_F2,     {"\033[[B",  "\033[24~", NULL,      NULL,       NULL}},
  {VK_F3,     {"\033[[C",  "\033[25~", NULL,      NULL,       NULL}},
  {VK_F4,     {"\033[[D",  "\033[26~", NULL,      NULL,       NULL}},
  {VK_F5,     {"\033[[E",  "\033[28~", NULL,      NULL,       NULL}},
  {VK_F6,     {"\033[17~", "\033[29~", "\036",    NULL,       "\036"}},
  {VK_F7,     {"\033[18~", "\033[31~", NULL,      NULL,       NULL}},
  {VK_F8,     {"\033[19~", "\033[32~", NULL,      NULL,       NULL}},
  {VK_F9,     {"\033[20~", "\033[33~", NULL,      NULL,       NULL}},
  {VK_F10,    {"\033[21~", "\033[34~", NULL,      NULL,       NULL}},
  {VK_F11,    {"\033[23~", NULL,       NULL,      NULL,       NULL}},
  {VK_F12,    {"\033[24~", NULL,       NULL,      NULL,       NULL}},
  {VK_NUMPAD5,{"\033[G",   NULL,       NULL,      NULL,       NULL}},
  {VK_CLEAR,  {"\033[G",   NULL,       NULL,      NULL,       NULL}},
  {'6',       {NULL,       NULL,       "\036",    "\036",     NULL}},
#define VK_GREYDIV 191                                                  
#define VK_GREYENT 13                                                    
  {VK_GREYDIV,{"\033[0o",  "\033[0o",  "\033[0o",  "\033[0o",  "\033[0o"}},
  {VK_MULTIPLY,{"\033[0j", "\033[0j",  "\033[0j",  "\033[0j",  "\033[0j"}},
  {VK_SUBTRACT,{"\033[0m", "\033[0m",  "\033[0m",  "\033[0m",  "\033[0m"}},
  {VK_ADD,    {"\033[0k",  "\033[0k",  "\033[0k",  "\033[0k",  "\033[0k"}},
  {VK_GREYENT,{"\033[M",   "\033[M",   "\033[M",   "\033[M",   "\033[M"}},
  {0,         {"",         NULL,       NULL,       NULL,       NULL}}
};                                                            
#endif
                                                              
#define VK_GREYDIV 191                                                
#define VK_GREYENT 13                                                 
struct {                                                      
  int vk;
  const char *val[5];
} keytable[] = {
/*           NORMAL      SHIFT        CTRL         ALT        SHIFTCTRL   */
{VK_LEFT,    {"\033[D",  "\033[D;2~", "\033[D;5~", "\033[D",  "\033[D;6~"}},
{VK_RIGHT,   {"\033[C",  "\033[C;2~", "\033[C;5~", "\033[C",  "\033[C;6~"}},
{VK_UP,      {"\033[A",  "\033[A;2~", "\033[A;5~", "\033[A",  "\033[A;6~"}},
{VK_DOWN,    {"\033[B",  "\033[B;2~", "\033[B;5~", "\033[B",  "\033[B;6~"}},
{VK_PRIOR,   {"\033[5~", "\033[5;2~", "\033[5;5~", "\033[5~", "\033[5;6~"}},
{VK_NEXT,    {"\033[6~", "\033[6;2~", "\033[6;5~", "\033[6~", "\033[6;6~"}},
{VK_HOME,    {"\033[H",  "\033[H;2~", "\033[H;5~", "\033[1~", "\033[H;6~"}},
{VK_END,     {"\033[F",  "\033[F;2~", "\033[F;5~", "\033[F",  "\033[F;6~"}},
{VK_INSERT,  {"\033[2~", "\033[2;2~", "\033[2;5~", "\033[2~", "\033[2;6~"}},
{VK_DELETE,  {"\033[3~", "\033[3;2~", "\033[3;5~", "\033[3~", "\033[3;6~"}},
{VK_F1,      {"\033[11~","\033[11;2~","\033[11;5~","\033[11~","\033[11;6~"}},
{VK_F2,      {"\033[12~","\033[12;2~","\033[12;5~","\033[12~","\033[12;6~"}},
{VK_F3,      {"\033[13~","\033[13;2~","\033[13;5~","\033[13~","\033[13;6~"}},
{VK_F4,      {"\033[14~","\033[14;2~","\033[14;5~","\033[14~","\033[14;6~"}},
{VK_F5,      {"\033[15~","\033[15;2~","\033[15;5~","\033[15~","\033[15;6~"}},
{VK_F6,      {"\033[17~","\033[17;2~","\033[17;5~","\033[17~","\033[17;6~"}},
{VK_F7,      {"\033[18~","\033[18;2~","\033[18;5~","\033[18~","\033[18;6~"}},
{VK_F8,      {"\033[19~","\033[19;2~","\033[19;5~","\033[19~","\033[19;6~"}},
{VK_F9,      {"\033[20~","\033[20;2~","\033[20;5~","\033[20~","\033[20;6~"}},
{VK_F10,     {"\033[21~","\033[21;2~","\033[21;5~","\033[21~","\033[21;6~"}},
{VK_F11,     {"\033[23~","\033[23;2~","\033[23;5~","\033[23~","\033[23;6~"}},
{VK_F12,     {"\033[24~","\033[24;2~","\033[24;5~","\033[24~","\033[24;6~"}},
{VK_NUMPAD5, {"\033[E",  "\033[E;2~", "\033[E;5~", "\033[E",  "\033[E;6~"}},
{VK_CLEAR,   {"\033[E",  "\033[E;2~", "\033[E;5~", "\033[E",  "\033[E;6~"}},
{VK_GREYDIV, {"\033[0o", "\033[0o",   "\033[0o",   "\033[0o", "\033[0o"}},
{VK_MULTIPLY,{"\033[0j", "\033[0j",   "\033[0j",   "\033[0j", "\033[0j"}},
{VK_SUBTRACT,{"\033[0m", "\033[0m",   "\033[0m",   "\033[0m", "\033[0m"}},
{VK_ADD,     {"\033[0k", "\033[0k",   "\033[0k",   "\033[0k", "\033[0k"}},
{VK_GREYENT, {"\033[M",  "\033[M",    "\033[M",    "\033[M",  "\033[M"} },
{0,          {NULL,      NULL,        NULL,        NULL,      NULL}}
};                                                                     
                                                                       
const char *                               
get_nonascii_key (INPUT_RECORD &input_rec, char *tmp)
{
#define control_key_state (input_rec.Event.KeyEvent.dwControlKeyState)
#define CTRL_PRESSED (LEFT_CTRL_PRESSED | RIGHT_CTRL_PRESSED)
#define ALT_PRESSED (LEFT_ALT_PRESSED | RIGHT_ALT_PRESSED)
#define NORMAL  0       /* NO modifier keys */
#define SHIFT   1       /* LEFT or RIGHT SHIFT */
#define CONTROL 2       /* LEFT or RIGHT CONTROL */
#define ALT     3       /* LEFT or RIGHT ALT */
#define SHIFTC  4       /* SHIFT-CONTROL */
  int i;
  int modifier_index = NORMAL;

  if (control_key_state & SHIFT_PRESSED){
    modifier_index = SHIFT;
    if(control_key_state & CTRL_PRESSED)
      modifier_index = SHIFTC;
  }
  else if (control_key_state & CTRL_PRESSED)
    modifier_index = CONTROL;
  else if (control_key_state & ALT_PRESSED)
    modifier_index = ALT;
    for (i = 0; keytable[i].vk; i++){
      if (input_rec.Event.KeyEvent.wVirtualKeyCode == keytable[i].vk)
        return keytable[i].val[modifier_index];
    }

  if ((i=input_rec.Event.KeyEvent.uChar.AsciiChar)!=0){
      tmp[0] = i;
      tmp[1] = '\0';
      if(modifier_index == ALT && isalpha(i)){
       tmp[2]='\0';
       tmp[1]=i;
       tmp[0]='\033';
      }
      return tmp;
  }
  return NULL;
}

/* Distinguish 10-key or shifted keypad and enhanced keys. Detect ALT. */
int isSpecialKey(unsigned vk, DWORD cks) {
  if((cks & NUMLOCK_ON)!=0) return 0;  /* keypad is 10-key */
  if((cks & ENHANCED_KEY)!=0) return 1;
  if((cks & ALT_PRESSED)!=0) return 1;
  if(vk==VK_MULTIPLY || vk==VK_SUBTRACT || vk==VK_ADD) return 1;
  return 0;
}

HANDLE get_the_io_handle(void){
static HANDLE h= (HANDLE)-1;
if(h == (HANDLE)-1){
 h = GetStdHandle(STD_INPUT_HANDLE);
}
return h;
}

int getchGNU(void){
static  char tmp[60]={0};
  HANDLE h = get_the_io_handle();
  int ch;

top:
  if (tmp[0]){
    ch=tmp[0]; strcpy(tmp,tmp+1);
    return ch;
  }

  for (;;)
    {
      DWORD nread;
      INPUT_RECORD input_rec;
      const char *toadd = NULL;

      if (!ReadConsoleInput (h, &input_rec, 1, &nread))
          return -1;            /* seems to be failure */

      /* check the event that occurred */
#define virtual_key_code (input_rec.Event.KeyEvent.wVirtualKeyCode)
#define control_key_state (input_rec.Event.KeyEvent.dwControlKeyState)
#define ich (input_rec.Event.KeyEvent.uChar.AsciiChar)
#define wch (input_rec.Event.KeyEvent.uChar.UnicodeChar)
#define ALT_PRESSED (LEFT_ALT_PRESSED | RIGHT_ALT_PRESSED)
#define CTRL_PRESSED (LEFT_CTRL_PRESSED | RIGHT_CTRL_PRESSED)
      switch (input_rec.EventType)
        {
        case KEY_EVENT:

          if (!input_rec.Event.KeyEvent.bKeyDown)
            continue;

          if (wch == 0 || isSpecialKey(virtual_key_code,control_key_state))
            { /* arrow/function/enhanced/alt keys */
              toadd = get_nonascii_key (input_rec, tmp);
              if (!toadd) continue;
              strcpy(tmp,toadd);
              break;
            }
          else
            {
              tmp[0] = ich; tmp[1]=0; toadd=tmp; break;
            }
          break;

        default:
          continue;
        }

      if (toadd) goto top; else break;
    }
  return -1;
}
#undef ich
#undef wch
#undef ALT_PRESSED
#undef CTRL_PRESSED
#undef ich

#if defined(__CYGWIN__)
#include <sys/termio.h>
#include <sys/ioctl.h>
#include <signal.h>
static struct termio tmp1;
static struct termio tmp2;

void termcanon(){
   ioctl(fileno(stdin), TCSETAF, &tmp2);
   signal(SIGHUP, SIG_DFL);
   signal(SIGTERM, SIG_DFL);
   signal(SIGINT, SIG_DFL);
   signal(SIGPIPE, SIG_DFL);
}

void termraw(){
    /* set it up the way we want it */
    ioctl(fileno(stdin), TCGETA, &tmp1);
    ioctl(fileno(stdin), TCGETA, &tmp2);
    tmp1.c_iflag &= ~ICRNL;
    tmp1.c_iflag &= ~IXON;
    tmp1.c_lflag &= ~ISIG;
    tmp1.c_lflag &= ~ICANON;
    tmp1.c_lflag &= ~ECHO;
    tmp1.c_iflag &= ~IGNBRK;
    tmp1.c_iflag &= ~BRKINT;
    ioctl(fileno(stdin), TCSETAF, &tmp1);
    signal(SIGHUP, SIG_IGN);
    signal(SIGTERM, SIG_IGN);
    signal(SIGINT, SIG_IGN);
    signal(SIGPIPE, SIG_IGN);
}

void settermout(void){
  setvbuf( stdout, NULL, _IONBF, 0 ); /* no buffering */
}
#else
void termcanon(){
}

void termraw(){
}

void settermout(void){
}
#endif

void main(void){
int n=0;
 settermout();
 termraw();
 printf("cygwin/gnu key banger. Shows emitted characters for a keypress\n");
 printf("Press a key. Quit with q, Q or ctrl-c.\n");
 while(1){
  int x;
  x=getchGNU(); 
  if(x=='\033' || x == '\r'){if(n) printf("\r\n"); n=0;}
  if(isprint(x)) printf("%c",x); else printf("[0x%02x]",x);
  if(++n==10){ printf("\r\n"); n=0;}
  if(x=='q' | x=='Q') break;
 }
 printf("\r\n");
 termcanon();
}
