.. PI manual, troff/nroff format. Convert with tr2tex.
.. Conversion: tr2tex -m pi.1 >pi.ltx
.. Display with "man ./pi.man"
.. Install in /usr/man/man1/pi.1
.\".VA
.TH PI 1L "14 Dec 2002"
.SH NAME
.B pi
\- Text editor for standard text files
.SH SYNOPSIS
Normal usage is:
.sp
.ce
\fBpi [switches] filelist\fP
.br
.sp
.in 0
where \fBfilelist\fP is a wildcard list of files to be edited or
created. Normally, no command line switches (see below) are required.
Without setup, the editor starts using accelerator key assignments, documented
on the menus. Two or four ESC keys activate the menu.

.br
.ne 12
.in 0
.SH DESCRIPTION
.sp
.in 0
The
.B PI
editor is a screen editor for text files. It creates and edits standard
text files from MS-Windows, Mac and Unix sources. Unique to the editor
is its bucket allocation scheme, which allows rapid reads of large files,
and its reduced keystroke scheme for common functions like searching,
block copies and moves, macro execution and paragraph reform.

.LP
.in 0
PI is an editor similar to the editors used in Borland International's
programming products and in Microsoft's EDIT. PI runs on MSDOS, Windows
9x/2000/XP, Linux and many Unix machines.
.br
.ne 15
.SH "MINI-MANUAL FOR PI"
.in 0
.sp
To start PI on any host:
.ce
.B pi
.br
.in 0
or
.br
.ce
\fB pi filename\fP
.LP
.in 0
where \fIfilename\fP is to be edited or created.
.ne 5
.SH "MENU COMMANDS"
.sp
.in 0
To start the menu press four ESC keys or two ENTER keys on the
application keypad of a 101 keyboard. The ctrl-underline key is a
one-key equivalent.
.LP
.in 0
The Menu is modeled after the MS-Windows standard, but activates
entirely with keystrokes rather than a mouse. Cursor keys move around
the menu, while the RETURN key selects an item. Cursor-type moves can
also be done by typing an alphanumeric character that matches a
character in the menu. The menu will appear something like the one
below:
.sp
.in 0
.ne 11
.nf
============================= Pi Editor =============================
  File  Keys  Tools  Search  Edit  Word  Block  Values  Other  Help
=====================================================================
                                                     +-----Help-----+
                                                     |Internal info |
                                                     |Brief manual  |
                                                     |HTML manual   |
                                                     |Set browser   |
                                                     |Text manual   |
                                                     |Quit editor   |
                                                     +--------------+
.fi
.sp
.LP
.in 0
To exit from the menu system, without doing anything, press SPACEBAR.
To execute an option, highlight it and press RETURN.
.LP
.in 0
The menu does the nucleus of editor operations. For example, to load a
new file, bring up the menu, choose \fIFile\fP and select \fIOpen\fP.
Press two RETURN keys to present a list of files. To select one to edit,
highlight it and press RETURN.
.LP
.in 0
The keystroke accelerator for a menu item is printed on the top line of
the screen. To see all possible key assignments, bring up the menu and
choose the \fIKeys\fP menu, item \fIKeymap editor\fP. This method
applies also to execute any editor command, even if no keys are assigned
to that editor function.
.br
.ne 15
.SH "ADDING AND DELETING KEYS"
.sp
.in 0
Unique to the editor is a simple interface for adding and deleting
accelerator key assigments. Bring up the "Keys" menu and choose "Keymap
editor" to invoke the interface. Keys hit during the session will cause
the editor to move the line which describes the function. Other keys
will be reported as "Unmapped". Keys can be added and deleted by
pressing "+" or "-".
.br
.ne 15
.SH "BRIEF COMMAND TABLE"
.sp
.in 0
Below is a brief table of commands used to control an editing session in
PI, cut down from the full command set, to give an idea of the learning
curve.
.br
.sp
.in 0
.TP 0.5in
Menu Key
.br
ctrl-underline
.br
Two ENTER keys on the application pad
.br
Four ESC keys

.TP
ENTER key
.br
Two ESC keys
.br
Keypad ENTER key
.br
F12 key 
.br
Keypad PLUS key

.TP
Delete char
.br
Left: BACKSPACE
.br
Right: DEL on the application pad

.TP
Position cursor
.br
Return, Tab, arrow keys move the cursor.
.br

.TP
Duplicate Cursor keys:
.br
Emacs  Wordstar  Universal
.br
ctrl-B  ctrl-S   left arrow
.br
ctrl-F  ctrl-D   right arrow
.br
ctrl-P  ctrl-E   up arrow
.br
ctrl-N  ctrl-X   down arrow

.TP
Next Page
.br
Emacs  Wordstar  Universal
.br
ESC-V   ctrl-R   PgUp (previous page)
.br
ctrl-V  ctrl-C   PgDn (next page)

.in 0
.TP
Block Copy/Delete
.br
The key F9 copies a line. Repeated application copies multiple lines.
Use F4 instead of F9 to copy the line and then delete it. Paste line is
F10, which pastes the group that was copied. See the menu items for
other keys.

.TP
Block Move
.br
Repeatedly delete lines (F4) or words. This removes the text from the
screen. To move the excised text, position the cursor to the new
location and paste (F10).

.TP
NotePad Cut and Paste.
.br
To copy lines or matrix regions to the NotePad, and optionally delete
from the screen, see Menu item `Block'. Also on this menu is the reverse
process of paste from notepad to buffer. The NotePad is organized as a
database of records. Any record can be pasted. By default, the last Cut
is pasted.

.TP
Step memorizer
.br
The key F7 repeats a sequence of keystrokes, memorized as
follows:
.br
 (1) Press F8 or menu `Keys' and item `Memorize keys'.
.br
 (2) Do the steps.
.br
 (3) Press F7 to stop.
.br
.sp
To save the memorized steps for later use, see menu "Keys" and item
"Save current macro".
.br
.sp

.ne 6
.SH "DOCUMENTATION"
.sp
.in 0
The \fIHelp\fP menu has items for internet browsers, text-only
documentation and a brief help screen which summarizes what is possible.
The two tested browsers are netscape and iexplore.exe (Microsoft internet
explorer). The text-only and html documentation are identical, both reading
file pihelp.htm.

.ne 6
.SH "BACKUPS AND VERSION CONTROL"
.sp
.in 0
The \fIFile\fP menu, item `Save to disk', puts a copy of the file on
disk, and it is a method for automatic backups while typing. Each such
save creates a new version on disk and the old version is kept in the
special directory \fB~/PIbackups\fP or the local directory
\fB./PIbackups\fP.
.br
.sp
.in 0
Version control is implemented as a rename of the original file. The
file name is truncated as necessary and then a unique extension is
added. For example, fool.c is renamed to fool.c.0000, then fool.c.0001,
and so on, using hexadecimal digits for the last four characters.
.br
.sp
.in 0
.ne 7
.SH COMMAND LINE OPTIONS.
.sp
.in 0
The complete syntax is:
.sp
.ce
              pi -dir:D -set:X -term:Y -key:Z -x FILE -gN
.sp
.in 0
where each switch is described below. The trailing switch -gN is used
most often. The other switches are rarely used at all.
.sp
.TP 1.0in
\-dir:D
Use directory D for support files.
.br
Example: pi -dir:/usr/local/lib/pie/wdstar/
.sp
.TP
\-set:X
Use setup file X. Example:
.br
pi  -set:/root/.pirc
.sp
.TP
\-term:Y
Select terminal type Y
.br
Example: pi  -term:vt100internal
.sp
.TP
\-key:Z
Use key map file Z
.br
Example: pi  -key:$HOME/emacs.key
.sp
.TP
\-gN
Go to line number N after file load
.br
Example: pi  paper.tex  -g4872
.sp
.TP
\-x
Setup for PI running in an xterm window.
.br
Example: xterm -fn fixed -e pi -x &
.sp
.TP
FILE
A wildcard file list separated by spaces.
.br
Example: pi paper.tex p*.bib intro.???

.sp
.in 0
The -x switch applies to X-term windows that have no shell for exit. It
disables a shell exit. The -g switch applies to the file name
immediately preceding it. One -g switch can be given for each file.
.br
.ne 8
.SH "INITIALIZATION"
.sp
.in 0
.LP
.in 0
TERMINAL. PI attempts to use system environment variables TERM and
TERMCAP to get terminal information. If these variables are unset, then
PI assumes vt100, but it complains. For a list of all terminals which
are supported by PI, execute the command `$PIE/tcapnames'.

.LP
.ne 9
.in 0
ENVIRONMENT. The environment variable PIEINIT is used to shorten the
command line syntax or to provide a default. The statement
.sp
.ce
setenv PIEINIT '-set:X -term:Y -key:Z'
.sp
.in 0
causes PI to reset its initial options. Subsequent command line switches
change the defaults. Only one `-term:' switch is used, namely the last
one to appear on the command line. Use of a `-key:Z' switch disables the
installation of a standard file.

.ne 15
.SH "CUSTOMIZATION OF PI"
.sp
.in 0
.LP
.in 0
RESOURCE FILE. The resource file `~/.pirc' sets defaults for the editor
like the backup mode, maximum screen size, initial insert mode and
similar features. This file is provided automatically if it is not present.
For example, deleting ~/.pirc will cause PI to create a new copy from
system default files.
To create and edit `~/.pirc' manually, here's how:
.sp
.ce
cp $PIE/emacs/SYSpi.rc  ~/.pirc
.ce
cp $PIE/wdstar/SYSpi.rc  ~/.pirc
.ce
cp $PIE/wdperf/SYSpi.rc  ~/.pirc
.sp
.in 0
Edit ~/.pirc to your liking. First-time users will not edit it at all.
.br
.sp
.br
The three possible selections of Emacs, WordStar or WordPerfect
emulation are set in the file `~/.pirc', on the line:
.sp
.ce
select.emulation=2;   Emacs==1, WordStar==2, WordPerfect==3.
.br
.sp
If emulation is not 1, 2 or 3, then WordStar is chosen.
.br
.ne 5
.SH FILES
.sp
.in 0
.TP 0.5in
$PIE, the directory, usually /var/lib/pie or /usr/local/lib/pie
.TP
$PIE/pihelp.htm
Manual source in hypertext format. It can be printed using unix
netscape or a similar internet browser.
.TP
/usr/local/bin/pi
Executable file.
.TP
$PIE/emacs/SYSpi.rc
.br
$PIE/wdstar/SYSpi.rc
.br
$PIE/wdperf/SYSpi.rc
.br
.ne 5
.SH "HISTORY OF PI"
.in 0
The editor grew initially out of a programming course at Utah in
1984, using language C. Student input on the editor design
shaped its improvements and determined the initial features.
.LP
.sp
.in 0
Unlike \fIemacs\fP, the editor grew up as a microcomputer text editor
for very small machines. The original 1984 editor was 12k bytes in size
and ran on \fICP/M\fP micros only. The model was an editor called the
\fIProgramma Improved Editor\fP, which was noted for its simplicity and
speed.
.LP
.in 0
The source code is available free. Contact the author by email or
download from the www site below.
.ne 8
.SH AUTHOR
.in 0
Grant B. Gustafson
.br
155 South 1400 East Rm233
.br
Salt Lake City, UT 84112-0090
.br
Tel: (801) 581-6879
.br
email: gustafson@math.utah.edu
.br
http://www.math.utah.edu/~gustafso/
