#include <stdio.h>
#include <sys/stat.h>
#include <sys/dirent.h>            
#include <sys/time.h>
#define DIR struct dirent
int main()
{
    int s;
    DIR *dir;                               
    struct dirent *entry;
    FILE *file;
    struct stat statptr;
    struct timeval tp;
    struct timezone tzp;
    time_t last_modified_time, current_time;


    /************************************/
    /* read the directory's contents,   */
    /* print out the name of each entry.*/
    /************************************/
    dir = (DIR *)opendir(".");

    if (dir == NULL ) printf("dir: file not found\n");

    printf("Directory contents:\n");

    while ((entry = (DIR *)readdir(dir)) != NULL)
    {
        printf("%s\n", entry->d_name);
    }
    printf("\n");

    closedir(dir);


    /************************************/
    /* now, we are going to print out   */
    /* how long a file has not been     */
    /* modified.                        */
    /************************************/
    s = stat("/u/ma/gustafson/pie/pie52/macOSX/example.c", &statptr);

    last_modified_time = statptr.st_mtime;
    gettimeofday(&tp, &tzp);
    current_time = tp.tv_sec;

    printf("The file example.c is not modified for %lu seconds.\n",
            current_time - last_modified_time);

    statptr.st_mode=0;
    s = stat("/u/ma/gustafson/pie/pie52/macOSX/example.c", &statptr);

    printmodes(statptr.st_mode);

    printf("The mode for example.c is %d [0x%x].\n",
           statptr.st_mode, statptr.st_mode );

    statptr.st_mode=0;
    s = stat("/u/ma/gustafson/pie/pie52/macOSX/example.foo", &statptr);

    printmodes(statptr.st_mode);

    printf("The mode for example.foo is %d [0x%x].\n",
           statptr.st_mode, statptr.st_mode );


    statptr.st_mode=0;
    s = stat("/u/ma/gustafson/pie/pie52/macOSX", &statptr);


    printf("The mode for this directory is %d [0x%x].\n",
           statptr.st_mode, statptr.st_mode );

    printmodes(statptr.st_mode);

    {int x= statptr.st_mode &  (S_IRWXU | S_IRWXG | S_IRWXO);

    printf("The file-create mode for this directory is %d [0x%x].\n",x,x);

    printmodes(x);
    }    

  {char s[512];
     getusageBSD(s);
     printf("%s\n",s);
  }

}

#include <sys/time.h>
#include <sys/resource.h>
int my_getrusage(n,r)
int n; struct rusage *r;
{
  getrusage(n, r);
}

int getusageBSD(s) char *s; {
struct rusage r;
  if(my_getrusage(RUSAGE_SELF,(struct rusage *)&r) == -1)
  s[0]=0; else
  sprintf(s,"Shared Text=%lu, Private Data=%lu",
              r.ru_maxrss, r.ru_idrss);
}











printmodes(x) int x; 
 { 
       if(S_IRWXU== (S_IRWXU & x))           printf("Read, write, execute by owner.\n");
       else {
       if(S_IRUSR== (S_IRUSR & x))           printf("Read by owner.\n");
       if(S_IWUSR== (S_IWUSR & x))           printf("Write by owner.\n");
       };
       if(S_IRWXG== (S_IRWXG & x))           printf("Read, write, execute by group.        \n");
       else {
       if(S_IXUSR== (S_IXUSR & x))           printf("Execute (search if a directory) by owner.\n");
       if(S_IRGRP== (S_IRGRP & x))           printf("Read by group.\n");
       if(S_IWGRP== (S_IWGRP & x))           printf("Write by group.\n");
       if(S_IXGRP== (S_IXGRP & x))           printf("Execute by group.\n");
       };
       if(S_IRWXO== (S_IRWXO & x))           printf("Read, write, execute (search) by  others.\n");
       else {
       if(S_IROTH== (S_IROTH & x))           printf("Read by others.\n");
       if(S_IWOTH== (S_IWOTH & x))           printf("Write by others.\n");
       if(S_IXOTH== (S_IXOTH & x))           printf("Execute by others.\n");
       };
 }



/*
       S_IRWXU      00700     Read, write, execute by owner.
       S_IRUSR      00400     Read by owner.
       S_IWUSR      00200     Write by owner.
       S_IXUSR      00100     Execute  (search  if  a  directory) by
                              owner.
       S_IRWXG      00070     Read, write, execute by group.
       S_IRGRP      00040     Read by group.
       S_IWGRP      00020     Write by group.
       S_IXGRP      00010     Execute by group.
       S_IRWXO      00007     Read, write, execute (search) by  oth-
                              ers.
       S_IROTH      00004     Read by others.
       S_IWOTH      00002     Write by others.
       S_IXOTH      00001     Execute by others.
*/
