#! /bin/sh
# Installs PI on a linux system from the zip source
PIEV=pie51
ZIPFILE=pie51src.zip
echo $PIEV $ZIPFILE
for x in ./ /usr/local/lib /var/lib; do
if test -d $x; then
  EXEDIR=$x/$PIEV
fi
done
echo EXE and support files for PI will be in $EXEDIR
for x in ./ /usr/src; do
if test -d $x; then
  SRCDIR=$x/$PIEV
fi
done
echo Source files for PI will be in $SRCDIR
SRCFILES="pie.c pie.h pieproto.h\
         MakeUnix keymap.dat pi.man tcapnames SYSpi.rc\
         wdstar.keys pihelp.htm whats.new emacs.keys pihelpbu.c\
         wdperf.keys printfilter chrset.txt install.sh xpi"
#
EXEFILES="keymap.dat tcapnames SYSpi.rc wdstar.keys pihelp.htm\
          emacs.keys pihelpbu wdperf.keys printfilter xpi v.exe"
#
mkdir $SRCDIR
unzip -q $ZIPFILE $SRCFILES -d $SRCDIR
mkdir $EXEDIR
unzip -q $ZIPFILE $EXEFILES -d $EXEDIR
for x in ./ /bin /usr/bin  /usr/local/bin; do
if test -d $x; then
  EXELINK=$x
  if test -f $EXELINK/pi; then
    mv $EXELINK/pi $EXELINK/pi.old
    echo Moved old PI link to $EXELINK/pi.old
  fi
  if test -f $EXELINK/xpi; then
    mv $EXELINK/xpi $EXELINK/xpi.old
    echo Moved old XPI link to $EXELINK/xpi.old
  fi
fi
done
ln -s $EXEDIR/v.exe $EXELINK/pi
ln -s $EXEDIR/xpi $EXELINK/xpi
echo New PI link is $EXELINK/pi
if test -d /usr/man/man1; then
 unzip -q $ZIPFILE pi.man -d /usr/man/man1
 mv /usr/man/man1/pi.man /usr/man/man1/pi.1
 echo Man page installed in /usr/man/man1/pi.1
fi



