#define LIBRARY 0       /* Eliminate Turbo C library */
/*
 * PIHELPB.C  Version April 2000
 *
 * Purpose: Prints out brief help information interactively.
 *          This program PIHELPB.EXE is called by pi.exe to give
 *          online brief help information at run time. It
 *          can be run stand-alone as well. To work with pi.exe
 *          the EXE should be named PIHELPB.EXE.
 *
 * To compile, assemble pihelpb.c using Turbo-C.
 *
   cc -d -Z -O pihelpb.c
 *
 * See the end of the file for a suitable makefile using no libraries.
 */

#include <stdio.h>
#define size(p) (sizeof(p)/sizeof(p[0]))
static
char *hlp[]={
"  [Function Keys][Basic Cursor Moves][Other Keys]Ŀ",
"   Full Help      ^OH Left    ^S    LeftArrow Line Ahead      ^Z or ^PgDn ",
"   Shell to DOS    F2 Right   ^D   RightArrow Line Back       ^W or ^PgUp ",
"   Insert Line     F3 Up      ^E      UpArrow System info             ^OO ",
"   Delete Line     F4 Down    ^X    DownArrow Detab mode and amount   ^OD ",
"   Search Ahead    F5 Page up      ^R or PgUp Word Wrap toggle        ^OW ",
"   Search Back     F6 Page Down    ^C or PgDn Auto Indent toggle      ^OI ",
"   Query Replace  ^QA Edge Left          HOME Insert char       ^V or INS ",
"   Record steps    F8 Edge Right          END Set Tab and margin      ^OT ",
"   Repeat steps    F7 Edge Bottom        ^END Delete char right ^G or DEL ",
"   Copy Line       F9 Edge Top          ^HOME Delete char left  BACKSPACE ",
"   Paste Line     F10 End of File  Enter PgDn Newline split-line      ^ON ",
"   Phrase copy    ^F9 Top of File  Enter PgUp Erase to end of line    ^QT ",
"   Phrase paste  ^F10[Buffers and Files]Ĵ Setup line/box draw     ^OL ",
"   Phrase kill    ^OZ Buffer Ahead         ^L Reform to margin        ^B  ",
"   Phrase->NotePad^OP Buffer list         ^KA Center line            ^O,c ",
"   SciCalc phrase^O,k Save & Exit         ^KX Copy line to NoteP Shift-F3 ",
"   Word to upper ^O,U Save & Scrap        ^KD Move line to NoteP Shift-F4 ",
"   Word to lower ^O,L Save As ...         ^KW Control codes: ^P then char ",
"   Word capital  ^O,C Save File (backup)  ^KS ENTER KEY:    Grey Enter    ",
"   Switch chars ALT-T Scrap File          ^KQĴ",
"   Switch lines ALT-L Paste File          ^KR[Quit Pi Editor]: ^U,^KZ,^KQ ",
"   Kill word       ^T Print File          ^KP[Menu]:     Dark* or ESC-ESC ",
"  ",
"    [KEYPAD CURSOR MOVES]             [ESCAPE KEYPAD MOVES]",
"  Ŀ",
"    Esc  ",
"  [ENTER]",
"  Ŀ  Ŀ",
"     7      8     9                     8    top  ",
"  Left     Up   Page                 search   of  ",
"  Edge    Char   up                  str Up  file ",
"  Ĵ  Ĵ",
"      4           6              4      5     6   ",
"    Left        Right          delete       grab  ",
"    char        char           char         char  ",
"  Ĵ  Ĵ",
"     1     2      3            Grab     2   bottom",
"  Right   Down  Page           word  search   of  ",
"  Edge    Char   down ENTER    token str Dn  file ",
"  Ĵ KEY     ",
"   0            .             [Press ESC twice, then the key]",
"      Insert Delete           ",
"      Toggle Char Rt          ",
"  ",
"",
"",
"",
"  LEFT KEYPAD       LEFT KEYPAD       LEFT KEYPAD",
"    [NORMAL]          [CTRL]           [SHIFTED]",
"Ŀ   Ŀ   Ŀ    RIGHT KEYPAD FUNCTIONS",
"  F1    F2       F1    F2       F1    F2        PRESS [CTRL] FIRST",
"CenterShell                   Text  System",
"screento DOS                  Help  comman   Ŀ",
"Ĵ   Ĵ   Ĵ      7      8     9   ",
"  F3    F4       F3    F4       F3    F4     Top of        Line  ",
"insertdelete                  CopyToMoveTo   Screen         up   ",
"line  line                    NotePdNotePd   Ĵ",
"Ĵ   Ĵ   Ĵ       4           6   ",
"  F4    F5       F4    F5       F4    F5      Left         Right ",
"searchsearch                                  Edge         Edge  ",
"ahead back                                   Ĵ",
"Ĵ   Ĵ   Ĵ      1     2      3   ",
"  F7    F8       F7    F8       F7    F8     Bottom        Line  ",
"start record                                 Screen         down ",
"macro macro                                  ",
"Ĵ   Ĵ   Ĵ",
"  F9    F10      F9    F10      F9    F10 ",
"Paste Copy      copy paste                    IBM-PC/XT/AT Keyboard",
"line  line     phrasephrase               ",
"      ",
"",
"                      [101 KEYBOARD FUNCTION KEYS]",
"       Ŀ",
"         F1    F2    F3    F4    F4    F5    F7    F8    F9    F10 ",
"Normal CenterShell insertdeletesearchsearchstart recordCopy  Paste ",
"       Screento DOSline  line  ahead back  macro macro line  line  ",
"       ",
"",
"       Ŀ",
"         F1    F2    F3    F4    F4    F5    F7    F8    F9    F10 ",
"Ctrl   Macro Keymap                                    copy  paste ",
"       EditorEditor                                    phrasephrase",
"       ",
"",
"       Ŀ",
"         F1    F2    F3    F4    F4    F5    F7    F8    F9    F10 ",
"Shift  Text        CopyToMoveTo                                    ",
"       Help        NotePdNotePd                                    ",
"       ",
"",
"",
"",
"",
"",
"",
"            [WORDSTAR LAYOUT FOR STANDARD QWERTY KEYBOARDS]",
"",
"Ŀ",
" Q     W      E     R     T     Y    U     I      O     P   ",
"Quick line  up    prev  erase deleteabort tab   Optionctrl  ",
"prefixup    arrow screenword  line  key   right prefixinsert",
"",
"   A     S      D     F     G     H     J      K    L    ",
"  left  left  right right deletedeleteSplit+File   switch",
"  word  arrow arrow word  right left  Returnprefix buffer",
"  ",
"     Z     X      C     V    B     N      M   ",
"    line  down  next  insertreforminsertnext  ",
"    down  arrow screentogglelines line  line  ",
"    ",
"",
"",
" Wordstar keys are executed by holding down [ctrl], then press the key",
"                   or keys required for the sequence.",
"",
"          For more help, press Shift-F1 while in the editor.",
"",
"",
""
};

/* These routinesreplace the Turbo-C routines of the same name */
/* See the Turbo-C manual for descriptions */
void clrscr()
{
void __int__();
/* This routine blanks the screen and puts the cursor on line 1 */
  _CX = 0; _DX = 0x184F; _BH = 7; _AX = 0x600;
  __int__(0x10);
  _AH = 2; _DX = 0; _BH = 0;
  __int__(0x10);
}

void aputc(c,attr) int c,attr; {
void __int__();
  _CX=1;
  _BH=0; _BL=attr;
  _AH=0x9; _AL=c;
  __int__(0x10);
}

void putcursor(rrow,ccol)
int rrow,ccol;
{
void __int__();
  _BH=0;                /* page 0 */
  _DH=rrow;
  _DL=ccol;             /* column */
  _AH=2;                /* set cursor position */
  __int__(0x10);
}

void cputs(row,col,s) int row,col; char *s; {
int attr = 0x07;        /* normal text */
int i=0; int x;
  while(*s) {
    x=s[0];
    if(x == '[') {attr = 0x70; x=' ';}  /* inverse video */
    else
    if(x == ']') x=' ';
    putcursor(row,col+i); aputc(x,attr); ++i;
    if(s[0] == ']') attr = 0x07;  /* normal video */
    ++s;
  }
}

int getch(){
void __int__();
  _AH=8; __int__(0x21); return (_AL);
}

void main() {
int i,j,k;
  for(k=j=0;j<size(hlp)/24;++j){
    clrscr();
    for(i=0;i<24;++i) cputs(i,0,hlp[k++]);
    cputs(24,0,"Press [RETURN] to continue, [Q] to quit: ");
    switch(getch()){
    case 'Q':
    case 'q':
    case 'S':
    case 's':
    case 'E':
    case 'e':
    case 3: goto quit;
    }
  }
quit: exit();
}

#if LIBRARY   /* eliminate Turbo C library */

#if 0
void _setenvp(void){}           /* dummy out _setenvp */

void _setargv(void){
extern int _argc; extern char **_argv;
static char *argv[1]={"C"};
  _argv=argv; _argc=1;
}

#endif
unsigned _stklen = 0x200;
unsigned _heaplen = 8192;

exit() {_exit();}
void _exitbuf(){}
void _exitfopen(){}
void _exitopen(){}

#endif

#if 0
/* batch file to put it together for no library */
/* need c0.asm from \tc\lib in Borland TC++ v3.0 (1988) */
c:\tc\tcc -c -ms -d -f- -Z -O -Ic:\tc\include pihelpb.c
tasm c0 /D__SMALL__ /D__NOFLOAT__ /D__OLDCONIO__ /t/mx
c:\tc\tlink c0 pihelpb /c/m,pihelpb

tc2.0 complains about _EMUSEG but the program compiles and runs.
Probably the error message can be forgotten, since it references
floating point code which is never used.
#endif





