#! /bin/sh
# Installs PI on a win32/cygwin system from the zip source
# Requires a cygwin setup and bash in a console window
# Best to run PI in an rxvt window due to mouse problems in
# the cygwin console. Cygwin kernel console driver stills lacks
# support for shifter keypad mode 2006. Use F12 instead of ENTER.
PIEV=pie53
ZIPFILE=pie53cygwin.zip
EXEDIR=/usr/local/lib/${PIEV}
SRCDIR=/usr/src/$PIEV
echo Install for $PIEV, zip file = $ZIPFILE
echo EXE and support files for PI will be in $EXEDIR
echo Source files for PI will be in $SRCDIR
SRCFILES="pie.c pie.h pieproto.h piesetup.h\
         MakeCygwin keymap.dat pi.man tcapnames SYSpi.rc\
         wdstar.keys pihelp.htm whats.new emacs.keys pihelpbu.c\
         wdperf.keys printfilter chrset.txt installCygwin.sh xpi"
#
EXEFILES="keymap.dat tcapnames SYSpi.rc wdstar.keys pihelp.htm\
          emacs.keys pihelpbu.exe wdperf.keys printfilter xpi v.exe"
#
mkdir $SRCDIR
unzip -q $ZIPFILE $SRCFILES -d $SRCDIR
mkdir $EXEDIR
unzip -q $ZIPFILE $EXEFILES -d $EXEDIR
for x in ./ /bin /usr/bin  /usr/local/bin; do
if test -d $x; then
  EXELINK=$x
  if test -f $EXELINK/pi; then
    mv $EXELINK/pi $EXELINK/pi.old
    echo Moved old PI link to $EXELINK/pi.old
  fi
  if test -f $EXELINK/xpi; then
    mv $EXELINK/xpi $EXELINK/xpi.old
    echo Moved old XPI link to $EXELINK/xpi.old
  fi
fi
done
ln -s $EXEDIR/v.exe $EXELINK/pi
ln -s $EXEDIR/xpi $EXELINK/xpi
echo New PI link is $EXELINK/pi
if test -d /usr/local/lib/pie; then
 echo /usr/local/lib/pie already exists, can't link it to $EXELINK  
else
 ln -s $EXEDIR /usr/local/lib/pie
 echo /usr/local/lib/pie ==> $EXELINK
fi
if test -d /usr/man/man1; then
 unzip -q $ZIPFILE pi.man -d /usr/man/man1
 mv /usr/man/man1/pi.man /usr/man/man1/pi.1
 echo Man page installed in /usr/man/man1/pi.1
fi
