#ifndef __GOT_PIE_H__
#define __GOT_PIE_H__    1 
#define thisVERSIONofPI     "PI 26-Jan-2003 Copyright by"
#include "piesetup.h"      /* defines compiler and OS */
/* Edit piesetup.h to define exactly one compiler and host OS */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#if SUN350      /* 0=off, SUN 3/50 or SUN 386/I */
#define VERSIONofPI "Sun350 "thisVERSIONofPI
#endif
#if IBMAIX      /* 0=off, IBM AIX Desktop */
#define VERSIONofPI "IBMaix "thisVERSIONofPI
#endif
#if ARDENT      /* 0=off, Ardent Titan switch   */
#define VERSIONofPI "Ardent "thisVERSIONofPI
#endif
#if DEC3100     /* 0=off, DEC 3100 switch       */
#define VERSIONofPI "Dec3100 "thisVERSIONofPI
#endif
#if DOS386I     /* 0=off, SUN386I, dos -w,TurboC*/
#define VERSIONofPI "Dos386i "thisVERSIONofPI
#endif
#if INDIGO      /* 0=off, Silicon Graphics unix */
#define VERSIONofPI "Indigo "thisVERSIONofPI
#endif
#if ALPHA       /* 0=off, DEC ALPHA switch      */
#define VERSIONofPI "Alpha "thisVERSIONofPI
#endif
#if WIN3        /* 0=off, Windows 9x/2000/xp    */
#define VERSIONofPI "Win3 "thisVERSIONofPI
#endif
#if LINUX       /* 0=off, Linux switch          */
#define VERSIONofPI "Linux "thisVERSIONofPI
#endif
#if CYGWIN      /* 0=off, cygwin/win9x/2000/xp  */
#define VERSIONofPI "Cygwin "thisVERSIONofPI
#endif                      
#if LCCWIN32    /* 0=off, lcc win32             */
#define VERSIONofPI "LccWin32 "thisVERSIONofPI
#endif
#ifndef VERSIONofPI
#define VERSIONofPI     thisVERSIONofPI
#endif
#if 0
AUTHOR          "G.B.Gustafson, 155 So 1400 East Rm233, SLC, UT 84112-0090"
ADDRESSofAUTHOR "gustafson@math.utah.edu, (801) 581-6879"
#endif
/*
 * V.H      Header file for editor files VG.C,V0.C,...,V13.C, Feb 1990
 *          Reorganized to pie.c for unix, cygwin, lccwin32 and the
 *          free Borland turbo-c++, 2002.
 *
 *    o TURBOC (alias WIZARD) is used for all DOS compiles. I have used
 *      Microsoft C, but find the ASM interface too difficult to maintain.
 *    o Switch MSDOS refers to operating-system and compiler-
 *      dependent code segments that affect IBM hardware and opsys.
 *    o The SUN350 switch is for SUN 3/50 and SUN 386/i, and most BSD4.x.
 *    o The ARDENT switch is for an Ardent Titan running Unix sys V with
 *      BSD extensions.
 *    o The DEC3100 switch is for Ultrix, essentially BSD 4.2. This risc
 *      machine still exists in 2002 under other names.
 *    o The DOS386I switch is for compiling a DOS version of PI to run
 *      under sun 386/i "dos -w" or "dos" with dos-based video plus
 *      multiple-terminal support. Unsupported since 1996.
 *    o Two defs, GLOBALS and KEYDEFS, are used to switch in and out
 *      global variable definitions and key definitions. See below.
 *    o MATHFLOAT variable controls code that loads the math library.
 *      Under Turbo-C, this adds 20k to the EXE file. Under Unix, with
 *      shared libraries, it adds **NOTHING** to the EXE file.
 *    o UseXMS variable switches MSDOS compile of xms features.
 */

/* Turn on/off the float code due to the calculator */
#define CALCULATOR      1               /* see v15.c and vee.c */
#define TURBOC          0               /* 0=off, Turbo C switch        */

/* some options only make sense on certain hardware                     */
#define BIOSSRC         0               /* 0=off, 1=Assemble int 10h,IBM*/
#define ANSISYS         0               /* 0=off, switch in ansi sys,IBM*/
#define IBMHARDWARE     0               /* 0=off, switch in IBM hardware*/
#define MONOEGAVGA      1               /* 1=mono/ega/vga(0=retrace cga)*/
#define CTRLU           'U'-'@'         /* single key, stop editor      */
#define CUSTOM          0               /* 0=off, Custom code, micros   */
#define far             /* */           /* meaningful on IBM-PC         */
#define CRLFtexttype    1               /* cr/lf delimited files        */
#define CRtexttype      2               /* cr delimited files  (MAC)    */
#define LFtexttype      3               /* lf delimited files  (UNIX)   */
#define BINtexttype     4               /* Binary files  (BINARY)       */
#define TERMCAP         0               /* 1=use termcap file, 0=don't  */
#define UseXMS          0               /* 1=use xms memory, 0=don't    */
#define BOXCHAR         0               /* 0=text,1=vga1,2=vga2         */

/* Switch for code that imports the float library, about 56k on a SUN4  */
/* and about 25k on a PC. Exception: just the basic convert2double()    */
/* will import no extra code (sprintf was already there) on a SUN4.     */

#if CALCULATOR
#undef MATHFLOAT
#define MATHFLOAT       1
#undef ssprintf
#define ssprintf        sprintf
#endif

#if !CALCULATOR
#undef ssprintf
#define ssprintf        sprintf
#endif

#if 0
#if !MATHFLOAT
#include <stdarg.h>
extern int  ssprintf(char *s,char *format, ...);
#endif
#endif            

#if LCCWIN32
#undef IBMAIX
#define IBMAIX 1
#include <time.h>
#include <errno.h>
#include <signal.h>
#include <direct.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <string.h>
#include <fcntl.h>
#include <conio.h>
#include <tcconio.h>
#include <setjmp.h>
#endif

#if DOS386I     /* sun386i running "dos -w" window, compiler Turbo-C    */

#undef  TURBOC
#define TURBOC          1
#endif          /* can be used on IBM-PC if you want bios+terminal types*/

#if WIN3        /* windows 3 in 386 enhanced mode, compatible windows */
#undef TURBOC
#define TURBOC          1
#endif

#if CYGWIN
#undef IBMAIX
#define IBMAIX 1
#endif

#if INDIGO
#undef IBMAIX
#define IBMAIX 1
#endif

#if LINUX
#undef IBMAIX
#define IBMAIX 1
#define PIEROOT "/usr/local/lib/pie"
#define mktemp mkstemp
#endif

#if ALPHA
#undef DEC3100
#define DEC3100 1
#endif

#if SUN350 || ARDENT || DEC3100 || IBMAIX /* sun 3/50, sun 386/i, BSD4.x*/
#define MEMORYDEBUG      1               /* Memory debug, other features */
#define SEGMEMORY       0               /* 8086 segmented memory model  */
#define BINARYIO        0               /* 0=off, Binary I/O switch     */
#define RMODE           "r"
#define WMODE           "w"
#define STATIC          auto            /* auto faster on SUN           */
#define REGISTER        register        /* SUN    can use 5 registers   */
#define LLong           int             /* SUN    has 32 bit integers   */
#define LLONG           int             /* SUN    has 32 bit integers   */
#define LLONGislong     0               /*  sizeof(LLONG)==sizeof(long) */
#define VOIDS           int
#define TRUE            1
#define FALSE           0
#define CRLFBOX         0
#define LFBOX           1
#define CRBOX           0
#define eread           read
#define ewrite          write
#define FILEP           FILE *
#if SUN350 || DEC3100
#define BSDunix         1
#define EXTENDED        1
#endif
#if ARDENT || IBMAIX
#define SYS5            1
#endif
#define SIZBLK          16384
#define MAXBL           8192/(SIZBLK/1024) /* Ext addr 8 megabytes   */
#define HASMEMCPY       1               /* Has memcpy(dest,src,count);  */
#define PIINILOAD       1               /* 0=off, Load ~/.pirc file      */
#define PIHELPDOC       1               /* 0=off, switch in pihelp.doc  */
#define PIHELPEXE       0               /* 0=off, switch in pihelp.exe  */
#define POPUPS 1                        /* popup windows adds 10k to EXE */
#define SHELLDEFAULT "csh"
#if LINUX
#undef SHELLDEFAULT
#define SHELLDEFAULT "sh"
#endif
#if CYGWIN
#undef SHELLDEFAULT
#define SHELLDEFAULT "bash"
#endif
#endif

#if LCCWIN32
#undef RMODE
#define RMODE           "rb"
#undef WMODE
#define WMODE           "wb"
#undef SHELLDEFAULT
#define SHELLDEFAULT "\\command.com"             /* regular shell to command.com  */
#endif


#if TURBOC
#define MEMORYDEBUG     1               /* Memory debug, other features */
#undef  BOXCHAR
#define BOXCHAR         2               /* 0=text,1=vga1,2=vga2         */
#undef  far
#define SEGMEMORY       1               /* 8086 segmented memory model  */
#define BINARYIO        1               /* 0=off, Binary I/O switch     */
#define RMODE           "rb"
#define WMODE           "wb"
#define STATIC          static          /* static fastest under TC      */
#define LLong           unsigned        /* Buffers less than 65535      */
#define REGISTER        register        /* TURBOC can use registers     */
#define VOIDS           void
#define TRUE            1
#define FALSE           0
#if 0
#define FILEP           int             /* use open and close */
#define fileno(x)       x               /* Undo stdio.h macro */
#else
#define FILEP           FILE *
#endif
#if DOS386I     /* sun386i running "dos -w" window, compiler Turbo-C    */
#define PIINILOAD       1               /* 0=off, Load PI.SET file      */
#define PIHELPDOC       1               /* 0=off, switch in pihelp.doc  */
#define PIHELPEXE       0               /* 0=off, switch in pihelp.exe  */
#undef BIOSSRC
#define BIOSSRC         0               /* use int 10, not direct video */
#else
#define MSDOS           1               /* MS-DOS OPS 3.x or 4.x        */
#define PIHELPDOC       0               /* 0=off, switch in pihelp.doc  */
#define PIHELPEXE       1               /* 0=off, switch in pihelp.exe  */
#endif
#undef IBMHARDWARE
#define IBMHARDWARE     1
#undef SWAPPER
#ifdef __SMALL__
#define SWAPPER         1       /* 1=on=Ralf Brown's __spawnv   */
#endif
#ifdef __MEDIUM__
#define SWAPPER         1      /* 1=on=Ralf Brown's __spawnv   */
#endif
/* spawno30.zip in mirrors/msdos at wuarchive.wustl.edu  anonymous ftp  */
/* New SPAWNO40.ZIP available. Uses 3.5k (Too Much!). See however V13.C */
/* Get it at ftp://oak.oakland.edu/ */
#ifdef SWAPPER                             /* for MS-C and TURBO-C         */
#define SHELLDEFAULT " "                       /* Swap to disk for Turbo-C     */
#define system  mysystem
#else
#define SHELLDEFAULT "\\command.com"             /* regular shell to command.com  */
#endif
/* MSDOS XMS memory extensions. */
/* If UseXMS==0 and LLONG=="unsigned", then the file size limit is 450k */
/* And no XMS memory is used. With UseXMS==1 and LLONG=="long int", the */
/* file size limit is about 8mb and XMS gets used in large hunks. */
/* Setup for NO XMS by setting the next #if to 0. */
#if 1
#undef UseXMS
#define UseXMS          1               /* 1=on=use xms memory, 0=off */
#define LLONG           long int        /* "unsigned" or "long int" */
#define LLONGislong     1               /*  sizeof(LLONG)==sizeof(long) */
#else
#undef UseXMS
#define UseXMS          0               /* 1=on=use xms memory, 0=off */
#define LLONG           unsigned        /* "unsigned" or "long int" */
#define LLONGislng     0               /*  sizeof(LLONG)==sizeof(long) */
#endif
#undef PIINILOAD
#define PIINILOAD       0               /* 0=off, Load PI.SET file      */
#if WIN3
#define setscroll(x)    ;
#undef PIINILOAD
#define PIINILOAD       1               /* 0=off, Load PI.SET file      */
#undef TERMCAP
#define TERMCAP         0               /* 0=no termcap file, 1=yes     */
#endif
/* many of these are optimized in assembly code */
#define HASABS          1               /* Has abs() function           */
#define HASMAXMIN       1               /* Has max, min functions       */
#define HASTOUPPER      1               /* Has toupper() K&R            */
#define HASISUPPER      1               /* Has isupper() K&R            */
#define HASFILLCHR      1               /* Has fillchr(dest,c,n)        */
#define HASSOB          1               /* Has char *sob(s)             */
#define HASFNB          1               /* Has char *fnb(s)             */
#define HASMIDSTR       1               /* Has midstr(s1,s2)            */
#define HASENDOF        1               /* Has char *endof(s)           */
#define HASSTRSTART     1               /* Has char *strstart(s)        */
#define HASDETAB        1               /* Has detab() in ASM module    */
#define HASTOTAL        1               /* Has total(hbuf,ebuf) in ASM  */
#define SIZBLK          4096            /* 4096, 8192 */
#define MAXBL           640             /* Far Ptr addressing to 512k   */
#define POPUPS 1                        /* popup windows adds 10k to EXE */
#define CRLFBOX         1
#define LFBOX           0
#define CRBOX           0
#endif

/* Switches for different processors */
#ifndef BSDunix
#define BSDunix         0               /* BSD 4.xx                     */
#endif
#ifndef SYS5
#define SYS5            0               /* Unix system V                */
#endif
#ifndef MSDOS
#define MSDOS           0               /* MS-DOS OPS 3.x or 4.x        */
#endif

#if BSDunix || SYS5
#include <signal.h>
extern void win_change();
#if !LCCWIN32
#undef TERMCAP
#define TERMCAP 1
#endif
#undef PIINILOAD
#define PIINILOAD 1
#endif

/* Following are library customizations to reduce code size             */
#ifndef HASMOVEMEM
#define HASMOVEMEM      0               /* Has movemem(dest,src,count); */
#endif
#ifndef HASMEMCPY
#define HASMEMCPY       0               /* Has memcpy(dest,src,count);  */
#endif
#ifndef HASFILLCHR
#define HASFILLCHR      0               /* Has fillchr(dest,c,n)        */
#endif
#ifndef HASSOB
#define HASSOB          0               /* Has char *sob(s)             */
#endif
#ifndef HASFNB
#define HASFNB          0               /* Has char *fnb(s)             */
#endif
#ifndef HASMIDSTR
#define HASMIDSTR       0               /* Has midstr(s1,s2)            */
#endif
#ifndef HASENDOF
#define HASENDOF        0               /* Has char *endof(s)           */
#endif
#ifndef HASSTRSTART
#define HASSTRSTART     0               /* Has char *strstart(s)        */
#endif
#ifndef HASDETAB
#define HASDETAB        0               /* Has detab() in ASM module    */
#endif
#ifndef HASTOTAL
#define HASTOTAL        0               /* Has total(hbuf,ebuf) in ASM  */
#endif
#ifndef HASCVUPPER
#define HASCVUPPER      0               /* Has cvupper(s) char *s;      */
#endif
#ifndef POPUPS
#define POPUPS          0
#endif

#ifndef IBMHARDWARE
#define IBMHARDWARE     0
#endif

#ifndef TERMCAP
#define TERMCAP         0
#endif

#if !SEGMEMORY
#define eread read
#define segcopy moveMEM
#endif

#undef min
#undef max
#undef abs

#define NULLP           (char *)0
#define EOS             '\0'
#define MACROTRUNC      42              /* macro title is truncated at 42 */
#define CPMEOF          26              /* Ctrl-Z marks CPM end of file */
#define HI128           0x8000          /* 256*128 - ENTER key bit 15   */

#define MKLEN 20
#if MSDOS
#define MAXFNAME 128    /* length of largest file name */
#define CDSIZE  128     /* length of largest path name */
#define MAXDIRENT 512   /* largest number of dir entries/subdir */
#endif
#if !MSDOS
#define MAXFNAME 256    /* length of largest file name */
#define CDSIZE  1024    /* length of largest path name */
#define MAXDIRENT 1024  /* largest number of dir entries/subdir */
#endif
struct fileinfo {
int active;     /* 0=not used, 1=all external, 2=uses main buffer */
char *fname;    /* file name */
int nbLOW;      /* number of low blocks used by file */
int nbTOT;      /* total number of blocks used by file */
int rowc;       /* cursor row, not used if active=2 */
int colc;       /* cursor col, not used if active=2 */
LLONG linec;    /* cursor line, not used if active=2 */
int dirty;      /* 0 if never touched, nonzero otherwise */
int curoffset;  /* screen offset, see drawall() */
int setmark;    /* text marker flag, 1=on,0=off */
int setmarkcol; /* absolute column marker where marker was set */
LLONG
 setmarkline;   /* line number where marker was set. */
int ReadFtype;  /* type on read 0=unix, 1=MSDOS, 2=MAC */
int WriteFtype; /* type on write 0=unix, 1=MSDOS, 2=MAC */
};

struct bucket {
 int record;    /* record in memblock[] array */
 int numlines;  /* number of lines in bucket */
 int numbytes;  /* number of bytes in bucket */
 int flag;      /* 0 if converted, 1 if not */
};

struct keybrd {
  int value;
  unsigned char *seq;
};

typedef char far * FARSTR;      /* FARSTR data is 4 bytes */
struct bigarray {FARSTR str;};  /* killerlist points to this structure */
struct biglist {                /* Container structure to hold saves */
  struct bigarray far *
      blockbase;                /* Address of the array of far strings */
  int
      blocklen;                 /* Number of strings in that array */
};

struct optinfo {char *descrip; int *val;};

struct swapchar {unsigned char old,new;};

struct menu { char *name; unsigned keycode; };

struct mainmenu {
char *name; unsigned offset; struct menu *pm;
char *title; unsigned items; unsigned hitrow;};

struct textinfo {
        int topcol;
        int toprow;
        int botcol;
        int botrow;
};

struct windows {
          char *title_center;                /* centered title */
          int top_row,top_col,               /* window coordinates*/
              bot_row,bot_col;
          struct textinfo oldw;              /* old window coordinates */
          char *info_center;                 /* centered information */
};


/* V1.C: RAW character input from getbyte(), processed by getkey() */
/* NULLKEY is returned by getkey() if sequence mismatches keymap */
/* Byt getkey() returns <> NULLKEY when getkeynchars==1  */
extern char *getkeybuf;         /* Where raw key hits are stored */
extern int getkeynchars;        /* How many chars are in getkeybuf */

#ifndef GLOBALS
/*
 * Editor global variables
 *
 *=========================================================================
 *                             GLOBAL VARIABLES
 *=========================================================================
 */
extern
int _egavga;            /* 1=mono/ega/vga, 0=retrace cga       */
extern
int abortkey;           /* single key, stop editor.            */
extern int markset;
extern int markcol;
extern LLONG markline;
extern int SYSATT;
extern int PRTleft,PRTtop,PRTbot,PRTlpp,PRTff;
extern int TABINSERT;
extern int repeats;
extern int repkey;
extern unsigned lastkey;
extern int MAXKILLER;
extern struct bigarray far *killerlist;
extern int killerlen;
extern int mouseswitch; /* X-windows mouse. 1=on, 0=off */
extern int hsens;       /* 8=on, 0=off. MSDOS only. */
extern int vsens;       /* 16=on, 0=off. MSDOS only. */
extern int KEYMODE;
extern int cursorCH;    /* VGA:  ch=1, cl=13 for cursor shape */
extern int cursorCL;
extern int swapswitch;  /* 1=on, 0=off used in DOS only */
extern int zero;        /* Search string char to match begin/end line */
extern int zeroleft;    /* TRUE if srcharg[0] is a zero token */
extern int zeroright;   /* TRUE if lastchar(srcharg) is a zero token */
extern char *MATHFMT;   /* Math format in printf style syntax "%.08g";*/
extern int blockflag;   /* Prompt for block read parameters */
extern int regdef;      /* 0=Region by lines, 1=by columns (toggle) */
extern int ACTIONSTART; /* 0=start UnTitled, 1=start with Menu */
#if MSDOS || DOS386I  /* Mapping of GREY keys on the keypad to other keycodes */
           /* Value is the msdos keycode replacement for the key */
           /* The code appears in routine ccBIOS (v8.c) */
extern
int GREYplus;           /* Grey plus==0x4e2b mapped to 0x8300=="Alt= " */
extern
int GREYast;            /* Grey asterisk==0x372a mapped to 0x0c1f=="Ctrl _" */
extern
int GREYent;            /* Grey enter==0xe00d mapped to 0x8300=="Alt =" */
extern
int STASHmin;           /* Memory blocks reserved for F9 string copies */
extern
int SUSPENDexit;        /*Suspend on ctrl-KX "Save then exit" FILE menu. */
#endif
#if !MSDOS
extern
int ansimode;           /* Flag for ansi mode */
extern
int textfgcolor;        /* Foreground text color 30-37 ANSI mode */
extern
int textbgcolor;        /* Background text color 40-47 ANSI mode */
extern
int menufgcolor;        /* Foreground menu color 30-37 ANSI mode */
extern
int menubgcolor;        /* Background menu color 40-47 ANSI mode */
extern
char *UNIXtextfgbg;     /* Unix text foreground+background ANSI */
extern
char *UNIXmenufgbg;     /* Unix menu foreground+background ANSI */
extern
char *UNIXdefaultfgbg;  /* Unix default foreground+background ANSI */
#endif

extern
char QUIT_PROMPT[];     /* "Quit Editor" Prompt for editor exit */
extern
char INSERTMODE[];      /* " [Insert]" Display for insert mode */
extern
char LINEDRAWMODE[];    /* "[Line Drawing]" Display for line drawing mode */
extern
char AUTHOR[];          /* "G.B.Gustafson, 155 So 1400 East Math.Dept. UofU, SLC, UT 84112-0090" */
extern
char ADDRESSofAUTHOR[]; /*  "http://www.math.utah.edu/~gustafso/, (801) 581-6879" */
extern
char NOTEPAD[];         /* "NotePad"  name of scratch buffer */
extern
char UNTITLED[];        /* "UnTitled" name of untitled file */
extern
char HELPSTR[];         /* " (Menu=Dark*)" or " (Menu=R2 or four ESC)" */

extern
int
  insmode,              /* insert mode toggle                   */
  tabstop,              /* tabstop variable                     */
  row ,                 /* row position 0...23                  */
  col ,                 /* column position 0...79               */
  macmax ,              /* maximum index in macbuf[]            */
  macrep ,              /* number of times to repeat macro      */
  macind ,              /* current index into macbuf[]          */
  macrun ,              /* macro running flag                  */
  sysarg ,              /* ENTER key numerical argument         */
  record ,              /* record keystrokes flag               */
  popcount ,            /* number of lines in push buffer       */
  nodisp ,              /* display flag, 0=on, 1=off            */
  statblank;            /* status line has been erased          */
extern
int
  STOPS,                /* tab stop increment                   */
  ROWMAX ,              /* rows numbered 0..22                  */
  COLMAX ,              /* columns numbered 0..79               */
  MAXROWS ,             /* most rows/screen, >= 1+ROWMAX        */
  MAXLN ,               /* longest line length                  */
  DOSTATUS,             /* Print status line during edit        */
  PIPEopen;             /* Status of open pipe, unix sys5/bsd   */
extern
int
  INDENAUTO,            /* auto indent toggle                   */
  HangingIndent,        /* Allow hanging indents                */
  WRDWRP,               /* word wrap toggle                     */
  margin,               /* right reform margin                  */
  BITSTRIP,             /* strip hit bit on = 1, off = 0        */
  DETABBER,             /* detab on = 1, off = 0                */
  BLANKSTRIP,           /* Strip blanks off end of line (1=on)  */
  TSTOPS,               /* screen tab stop                      */
  grabchar,             /* obsolete                             */
  FOLDCASE,             /* fold case on search                  */
  MAXMB,                /* size of macro recording buffer       */
  INSMD,                /* State of initial insert mode         */
  drawstyle,             /* Style of box/line-drawing chars     */
  intexttype,           /* Import text type 1=MSDOS,2=MAC,3=UNIX*/
  outtexttype,          /* Export text type 1=MSDOS,2=MAC,3=UNIX*/
  ReportExportImport,   /* Report Export-Import type            */
  titlattr,             /* Window title color attribute         */
  windattr,             /* Window color attribute               */
  bordattr,             /* Window border color attribute        */
  boxcharset,           /* Box characterset 0=text,1=latin1,2=latin2 */
  BACKUPS,              /* 0=NO,1=~/PIbackups,2=./PIbackups     */
  EMACSMODE;            /* cr inserts cr/lf by default          */
extern char *
  BROWSER;               /* Choose a default browser */
extern int
  drawline;             /* State of box/line-drawing switch     */
extern
LLONG
  lncount;              /* line number variable                 */
extern
char
  PiVersion[];          /* version string for PI editor         */
extern
char
  *progname;            /*  Program name from argv[0] */
extern
char
  *PIBACKUPS;           /* Directory name for backups */
extern
char *cd;               /* connected dir pointer                */
extern
char *SHELL;            /* Name of command shell */
extern
char
  *srcharg,             /* pointer to search argument string    */
  *lastarg,             /* */
  *replarg,             /* pointer to replace argument string   */
  *sysfile,             /* command line filename                */
  *sysv,                /* pointer to system scratch buffer     */
  *sysx,                /* pointer to system scratch buffer     */
  *sysvv,               /* pointer to system scratch buffer     */
  *bufbase,             /* edit buffer base (absolute)          */
  *lbuf,                /* lower buffer end (movable)           */
  *hbuf,                /* high buffer start (movable)          */
  *ebuf,                /* end of edit buffer + 1 (movable)     */
  *scrbuf,              /* screen buffer pointer (fixed)        */
  *macbuf,              /* memorization buffer pointer (fixed)  */
  *optbuf;              /* pointer to optional line buffer      */
extern
char
  **line;               /* pointers to 24 screen lines          */
extern
int
  taberr,               /* error count variable for tabs        */
  HEADROOM,             /* must be > 1+MAXLN+SIZEBLOCK          */
  LINESIZE,             /* usually (1+MAXLN)*sizeof(char *)     */
  SCRSIZE,              /* usually (1+MAXLN)*(1+ROWMAX)         */
                        /* but also SCRSIZE >= HEADROOM         */
  FARSCROLL;            /* must be > ROWMAX                     */

extern
int MAXKEYS;

extern
unsigned char *LeadinSTR;
      
extern
struct keybrd ourkeys[];

#if MSDOS
#if ANSISYS
extern char
       *rs_termcap    ,                 /* reset terminal */
       *is_termcap    ,                 /* init terminal */
       *ks_termcap    ,                 /* start keypad shifted mode */
       *ke_termcap    ,                 /* exit keypad shifted mode */
       *al_termcap    ,                 /* insert line */
       *dl_termcap    ,                 /* delete line */
       *ce_termcap    ,                 /* erase to end of line */
       *cd_termcap    ,                 /* clear to end of display */
       *cm_termcap    ,                 /* cursor motion */
       *cs_termcap    ,                 /* change scrolling region */
       *sf_termcap    ,                 /* scroll forward */
       *sr_termcap    ,                 /* scroll reverse */
       *bl_termcap    ,                 /* audible bell */
       *pc_termcap    ,                 /* pad char (null) */
       *REVVIDEO      ,                 /* enter inverse video (so) */
       *NORMVIDEO     ,                 /* exit inverse/bold video (se) */
       *BOLDF         ;                 /* enter boldface chars (md) */
#endif
extern char
       *ERACHR        ,                 /* erase char left */
       *INIFILE       ;                 /* keyboard file name */
extern int
       HASSCROLL      ,                 /* cs && sf && sr */
       HASINSERTLINE  ,                 /* HASSCROLL || *al_termcap */
       HASDELETELINE  ,                 /* HASSCROLL || *dl_termcap */
       ospeed         ;                 /* output speed of terminal */
extern char *termtype;
#endif

extern
int MAXFN;          /* max length of a file name */
extern
int SIZEBLOCK;      /* depends on disk controller & OS */
extern
int SIZEKBLOCK;     /* Size in kilobytes, SIZEBLOCK/1024 */
extern
int USEDBLOCK;      /* number of blocks in use */
extern
int FREECORE;
extern
int MAXBLOCK;       /* MAX number of memory blocks */
extern
int MAXXMS;         /* Max MSDOS xms memory blocks (himem.sys) */
extern
int MACNUM;         /* Global counter for macro buffers     */
extern
char **macrobuf;   /* macro buffer pointers */
extern
int *macromax;     /* macro buffer counters */

#if 0
struct bucket **  /* bucket info array */
meminfo;
#else
extern
struct bucket far *  /* bucket info array */
meminfo;
#endif
extern
FARSTR far *            /* bucket addresses */
memblock;
extern
char far * memmark;
extern
unsigned far * handles; /* handles for TURBOC xms routines */

extern
int maxinfo;            /* max number of files resident in editor */
extern
int curfile;            /* currently active file 0...(maxinfo-1) */
extern
int curoff;             /* current screen offset, see drawall() */
extern
struct fileinfo
*finfo;
/* finfo[]; */

#if !MSDOS

extern char
       *rs_termcap    ,                 /* reset terminal */
       *is_termcap    ,                 /* init terminal */
       *ks_termcap    ,                 /* start keypad shifted mode */
       *ke_termcap    ,                 /* exit keypad shifted mode */
       *al_termcap    ,                 /* insert line */
       *dl_termcap    ,                 /* delete line */
       *ce_termcap    ,                 /* erase to end of line */
       *cd_termcap    ,                 /* clear to end of display */
       *cm_termcap    ,                 /* cursor motion */
       *cs_termcap    ,                 /* change scrolling region */
       *sf_termcap    ,                 /* scroll forward */
       *sr_termcap    ,                 /* scroll reverse */
       *bl_termcap    ,                 /* audible bell */
       *pc_termcap    ,                 /* pad char (null) */
       *REVVIDEO      ,                 /* enter inverse video (so) */
       *NORMVIDEO     ,                 /* exit inverse/bold video (se) */
       *BOLDF         ,                 /* enter boldface chars (md) */
       *ERACHR        ,                 /* erase char left */
       *INIFILE       ;                 /* keyboard file name */
extern int
       HASSCROLL      ,                 /* cs && sf && sr */
       HASINSERTLINE  ,                 /* HASSCROLL || *al_termcap */
       HASDELETELINE  ,                 /* HASSCROLL || *dl_termcap */
       ospeed         ;                 /* output speed of terminal */
extern char *termtype;
#endif

#endif  /* ifndef GLOBALS */


#ifdef KEYDEFS
/*
 * KEY DEFINITIONS FOR PI EDITOR
 *
 *      The table below defines unique integers 1000...2000 for
 *      each function of the editor.  The values are selected by the
 *      designer - they are used internally only. Prefixed keys are
 *      handled similarly - for example, ENTER + ctrl-E is assigned
 *      an integer code, which is treated by the editor as a single
 *      keystroke, even though the code requires two key presses.
 */
#define WASENTER        5000            /* Flag to mark enter key combo */
#define TABKEY          1001            /*  TAB key or ctrl-I            */
#define RETURNKEY       1002            /*  RETURN key or ctrl-M         */
#define REVTABKEY       1003            /*  Reverse tab                  */
#define UPARROW         1004            /*  Up arrow                     */
#define DOWNARROW       1005            /*  Down arrow                   */
#define LEFTARROW       1006            /*  Left arrow                   */
#define RIGHTARROW      1007            /*  Right arrow                  */
#define HOMEKEY         1008            /*  Home cursor [1,1]            */
#define INSERTLINE      1009            /*  Insert line                  */
#define DELLINE         1010            /*  Delete line                  */
#define DELCHAR         1011            /*  Delete char                  */
#define INSMODE         1012            /*  Insert toggle                */
#define FWDSEARCH       1013            /*  Search forward, F5           */
#define REVSEARCH       1014            /*  Search reverse, F6           */
#define ENTERKEY        1015            /*  Enter key [ESC and dark plus]*/
#define PAGEFORWARD     1016            /*  Page forward [PgDn]          */
#define LINEFORWARD     1017            /*  Line forward [ctrl-Z]        */
#define FILETOP         1018            /*  Top of file                  */
#define LINEBACK        1019            /*  Line backward                */
#define PAGEBACK        1020            /*  Page backward                */
#define ERASEKEY        1021            /*  Erase to end of line         */
#define RUNMEMORIZE     1022            /*  Run macro, F7                */
#define PUSHKEY         1023            /*  Copy line to push buffer     */
#define POPKEY          1024            /*  Print line from push buffer  */
#define SAVE_EXIT       1026            /*  ctrl-KX,  save and exit      */
#define DSKFILES        1027            /*  Print disk dir, ctrl-KF      */
#define LOAD            1028            /*  Load new file, ctrl-KL       */
#define INJECT          1029            /*  Inject file, ctrl-KR         */
#define SPLITLINE       1031            /*  Split line, ctrl-ON          */
#define BACKUP          1032            /*  Save file, ctrl-KS           */
#define CONTROLENTRY    1033            /*  Next char ctrl, ctrl-P       */
#define BAILOUT         1034            /*  Quit edit, ctrl-KQ & ctrl-U  */
#define GRABTEXT        1035            /*  Grab text from screen        */
#define ADDBUFFER       1036            /*  Append line to NotePad       */
#define SETTABS         1037            /*  Tabstop=cursor, ctrl-OT      */
#define SETSTATUS       1038            /*  Status line toggle, ctrl-OS  */
#define SETAUTO         1039            /*  Toggle auto indent, ctrl-OI  */
#define REFORMKEY       1040            /*  Reform line, ctrl-B          */
#define RECORDING       1041            /*  Start recording, F8          */
#define RUNPROGRAM      1042            /*  run command.com              */
#define RUNHELP         1043            /*  run help (pihelp .exe/.doc)  */
#define WORDWRAP        1044            /*  Toggle word wrap, ctrl-OW    */
#define NEXTEDIT        1048            /* next buffer forward, ctrl-L   */
#define SAVE_NEXT       1049            /*  ctrl-KD, save, edit next     */
#define EXTENDEDCHAR    1050            /* ctrl-OE, prev |= 128          */
#define SETDETAB        1051            /* ctrl-OD, set detab toggle     */
#define SETSTRIP        1052            /* ctrl-OB, bit stripper toggle  */
#define OPTIONSET       1053            /* ctrl-OO, show options         */
#define FOLDSRCH        1054            /* ctrl-OF, fold case toggle     */
#define SCRAPBUFFER     1055            /* ctrl-KQ, scrap buffer         */
#define TSRKEY          1080            /* ctrl-KZ, kill process & exit  */
#define CASELOWER       1081            /* ctrl-O,l case char lower      */
#define CASELLOWER      1082            /* ctrl-O,L case line lower      */
#define CASEUPPER       1083            /* ctrl-O,u case char upper      */
#define CASELUPPER      1084            /* ctrl-O,U case line upper      */
#define NULLKEY         1085            /* Null key - do nothing         */
#define SAVEASKEY       1086            /* ctrl-KW save file as ....     */
#define GOTOKEY         1087            /* ctrl-OG goto line #  ....     */
#define MENUKEY         1088            /* POPUP menu for Turbo-C        */
#define NEWSEARCH       1089            /* ctrl-QN new search string     */
#define CENTERTEXT      1090            /* ctrl-O,c center text on line  */
#define APPENDLINE      1091            /* ctrl-OA append line to NotePad*/
#define KILLNOTEPAD     1092            /* ctrl-OX clear NotePad         */
#define NEWLOAD         1093            /* ctrl-KU New file name         */
#define RUNBHELP        1094            /* ctrl-O,h Run brief help       */
#define MANYRUNMEM      1095            /* ctrl-OJ  Run macro nnn times  */
#define LINEDRAWKEY     1096            /* ctrl-OL Toggle line draw      */
#define SETTEXTTYPE     1098            /* ctrl-KT Set In/Out text type  */
#define NAMECHANGE      1099            /* ctrl-KN Change filename       */
#define QPUSHKEY        1100            /* ctrl-OC Substring Copy        */
#define QPOPKEY         1101            /* ctrl-OV Optional Paste        */
#define OPTPUSHKEY      1102            /* ctrl-OP optbuf to notepad     */
#define QZAPKEY         1103            /* ctrl-OZ delete optbuf match   */
#define DELMANYLINES    1104            /* ctrl-OY delete many lines     */
#define EXTRIGHTARROW   1105            /*  Right edge                   */
#define EXTLEFTARROW    1106            /*  Left edge                    */
#define DEFINEKEY       1107            /*  Define key ctrl-O,=          */
#define DUMPKEYS        1108            /*  make "pi-dump.key" ctrl-O,+  */
#define SHRINKWINDOW    1109            /*  shrink window size ctrl-O,-  */
#define QUERYREPLACE    1110            /*  Query/replace fwd  ctrl-QQ   */
#define KEYSLOADUP      1111            /*  Load key map file  ctrl-Q,@  */
#define REVHOMEKEY      1112            /*  Cursor [24,1]                */
#define FILEBOTTOM      1113            /*  Cursor to bottom of file     */
#define PASTEBLOCK      1114            /*  ctrl-K,p   paste block       */
#define MOVEBLOCK       1116            /*  ctrl-K,m   move block        */
#define COPYBLOCK       1118            /*  ctrl-K,c   copy block        */
#define ERASELINE       1120            /*  Erase whole line  ctrl-QY    */
#define PREVEDIT        1121            /*  ctrl-QL previous edit window */
#define RUNMYPROGRAM    1122            /*  ctrl-O,R run system program  */
#define FOREIGNKEY      1123            /*  swap char to foreign equiv   */
#define SETMARK         1124            /*  mark block ctrl-KB           */
#define REVEALMARK      1125            /*  show block ctrl-K,s          */
#define SWAPMARK        1126            /*  swap mark and point ctrl-KK  */
#define DISPLAYMACRO    1127            /*  Reveal codes for a macro     */
#define CASECAPITAL     1128            /* ctrl-O,C case word capitalize */
#define WORDAHEAD       1129            /*  Ctrl-F cursor on word ahead  */
#define WORDBACK        1130            /* Ctrl-A cursor one word back   */
#define COLORSET        1131            /* Set foreground & background   */
#define CHARTRANSPOSE   1132            /* Transpose chars at cursor     */
#define LINETRANSPOSE   1133            /* Transpose lines at cursor     */
#define WORDERASE       1134            /* Erase word at cursor          */
#define PRINTFILE       1135            /* Format buffer for printer     */
#define ASCIITABLE      1136            /* Overlay ascii table on status */
#define SETPRINTER      1137            /* setup routine for printer     */
#define REPEATKEY       1138            /* Set repeat count for next key */
#define POPLIST         1139            /* Pop kill list into buffer     */
#define PURGELIST       1140            /* Purge kill list               */
#define BACKTOGGLE      1141            /* Toggle backups                */
#define SETEMACSMODE    1142            /* Set Emacs mode                */
#define SETWDSTARMODE   1143            /* Set WordStar mode             */
#define SETWDPERFMODE   1144            /* Set WordPerfect mode          */
#define EMACSRETURNKEY  1145            /* Return key inserts crlf       */
#define CURSORSTYLESET  1146            /* Set cursor style hi, lo       */
#define COMPLETEKEY     1147            /* Keymap and macro editor       */
#define MOUSEPRESS      1148            /* Process mouse press unix      */
#define MOUSERELEASEVALID 1149          /* Valid mouse release unix      */
#define MOUSERELEASEINVALID 1150        /* Invalid mouse release unix    */
#define SETMOUSE        1151            /* Enable mouse unix             */
#define UNSETMOUSE      1152            /* Disable mouse unix            */
#define OPTMATH         1153            /* Replace optbuf by math answer */
#define OPTFILE         1154            /*ctrl-K,o replace optbuf by file*/
#define SWAPSW          1155            /*ctrl-K,s swap switch           */
#define SETBUFFER       1156            /* ctrl-KA Change edit buffer    */
#define LFWDSEARCH      1157            /*  Line Search forward          */
#define LREVSEARCH      1158            /*  Line Search reverse          */
#define ZEROTOKEN       1159            /* Insert ZERO token (==cr/lf)   */
#define OPTMATHFLOAT    1160            /* ctrl-O,j optbuf float math    */
#define MATHFORMAT      1161            /* ctrl-OM set math format string*/
#define OPTEVALEXPR     1162            /* Apply expression evaluator    */
#define KILLKEY         1163            /* Kill a key definition         */
#define SETBOOKMARK     1164            /* Set bookmark 0                */
#define GOBOOKMARK      1165            /* GOTO bookmark 0               */
#define CENTERREFRESH   1166            /* Refresh and center at cursor  */
#define VIDEOMODE       1167            /* Set video mode                */
#define NEWWINSIZE      1168            /* Set new window size Xwindows  */
#define RUNBACKGROUND   1169            /* Execute script in background  */
#define RELOAD          1170            /* Reload current file from disk */
#define MACROLIBRARY    1171            /* Run macro library editor      */
#define OPTHEX          1172            /* Convert optbuf[] hex->dec     */
#define OPTOCT          1173            /* Convert optbuf[] oct->dec     */
#define SETHANGING      1174            /* Toggle hanging indent mode    */
#define HELPHTML        1175            /* hypertext help browser        */
#define HELPBROWSER     1176            /* browser name                  */
#define READPIPE        1177            /* Inject system command pipe    */
#define MENUBOXSET      1178            /* Menu box character set        */
#define SETBLANKSTRIP   1179            /* Toggle strip trailing space   */
#define SHOWKEYPRESS    1180            /* Show chars in keypress        */
#define CREATEFOLDER    1181            /* Make new folder/dir           */
/*  */
#define FOREIGNLOAD     14999           /* Loadup foreign= string        */
/* MACROKEY-1 is the biggest allowed number for non-macro codes          */
#define MACROKEY       15000            /* alt-0 save macro to key       */
/* Any code > MACROKEY is a macro. We use macrobuf[code-MACROKEY].       */
#endif /* ifdef KEYDEFS */

/* end of v.h */

#endif          /* End of #ifndef __GOT_PIE_H__  */
