/******************************************************************************/
/* VMXTRN.H: External declarations for VM public variables.
*/
/******************************************************************************/
/* Scalar variables.
*/
extern int boundsw;           /* 1=prefix RS; 2=trim RE; 3=both; 0=neither. */
extern int cdirsw;            /* 1=search current dir only; 0=use path. */
extern int eltrsv;            /* Save eltrsw during prolog. */
extern int eltrsw;            /* 1=trace element structure in error msg; 0=no.*/
extern int tpes;              /* Index of current source in stack. */
extern int prntmax;           /* Number of data or PI chars to print. */
extern int src;               /* Return code from call to SGML services. */
extern int srmsw;             /* 1=SHORTREF maps in use; 0=not used. */
extern int suppsw;            /* 1=suppress parsing info; 0=report it. */
extern int tpts;              /*Current index in tptags(initialize each pass.)*/
extern UNCH *curfile;         /* Current file for messages. */
extern UNS cnterr;            /* Number of errors reported. */
extern UNS readcnt;           /* Number of bytes for DOS file read. */
/******************************************************************************/
/* Arrays and structures.
*/
extern UNIV srcbp;            /* Ptr to SGML's RCB/IPB. */
extern struct ad *alptr;      /* Current attribute list (tag or data). */
extern struct entity *oldent; /* Most recent entity parsed. */
extern struct ipbt it;        /* IPB: To SGML for parsing and services. */
extern struct ipbt *itlpu;    /* Address of it. */
extern struct source tpscbs[];/* Stack of open sources ("SCB stack"). */
extern struct switches tpsw;  /* Parser control switches set by text proc. */
extern UNCH pd[];             /* Place for data copied from SGML data space. */
extern UNCH *ld;              /* In pd: Buffer for copied literal. */
extern UNCH *path;            /* In pd: file ID buffer: len+path\fileid+EOS. */
extern UNCH tptags[][NAMELEN+1]; /* Text processor element structure stack. */
/******************************************************************************/
/* Constants.
*/
extern UNCH *eminmsg[];       /* End-tag minimization messages. */
extern UNCH *genext[];        /* Generated external entity file types. */
extern UNCH *realmsg[];       /* Real tag portion of minimization messages. */
extern UNCH *msgfptr;         /* Pointer to actual SGML message file id. */
extern UNCH options[];        /* Text for invalid option error message. */
/******************************************************************************/
/* Conditional inclusions
*/
#ifdef V2
extern UNCH *formats[];       /* Formatting procedures for chainsaw sculpture.*/
#endif
/******************************************************************************/
