/******************************************************************************/
/* Use shortened external names.  Remove /X from parameter message.           */
/******************************************************************************/
#include "vmincl.h"           /* Include files for VM. */
/******************************************************************************/
/* VMXTRN: Storage allocation and initialization for VM public variables.
*/
/******************************************************************************/
/* Scalar variables.
*/
int boundsw = '3';            /* 1=prefix RS; 2=trim RE; 3=both; 0=neither. */
int cdirsw = 0;               /* 1=search current dir only; 0=use path. */
int eltrsv = 1;               /* Save eltrsw during prolog. */
int eltrsw = 0;               /* 1=trace element structure in error msg; 0=no.*/
int tpes = 1;                 /* Index of current source in stack. */
int prntmax = 10;             /* Number of data or PI chars to print. */
int src = 0;                  /* Return code from call to SGML services. */
int srmsw = 0;                /* 1=SHORTREF maps in use; 0=not used. */
int suppsw = 0;               /* 1=suppress parsing info; 0=report it. */
int tpts = 0;                 /*Current index in tptags(initialize each pass).*/
UNCH *curfile = 0;            /* Current file for messages. */
UNS cnterr = 0;               /* Number of errors reported. */
UNS readcnt = 512;            /* Number of bytes for DOS file read. */
/******************************************************************************/
/* Arrays and structures.
*/
UNIV srcbp = 0;               /* Ptr to SGML's RCB/IPB. */
struct ad *alptr = 0;         /* Current attribute list (tag or data). */
struct entity *oldent = 0;    /* Most recent entity parsed. */
struct ipbt it = {0};         /* IPB: To SGML for parsing and services. */
struct ipbt *itlpu = &it;     /* Address of it. */
struct source tpscbs[ENTLVL+1] = {0}; /* Stack of open sources ("SCB stack"). */
struct switches tpsw = {0};   /* Parser control switches set by text proc. */
UNCH pd[2*LITLEN+FILESPEC+6] = {0}; /* Place for data copied from SGML space. */
 UNCH *ld = pd+LITLEN+2;       /* In pd: Buffer for copied literal. */
 UNCH *path = pd+2*LITLEN+4;   /* In pd: File ID buffer: len+path\fileid+EOS. */
UNCH tptags[TAGLVL+1][NAMELEN+1] /* Text processor element structure stack. */
     = {"*DOC"};
/******************************************************************************/
/* Constants.
*/
UNCH *eminmsg[] = {           /* End-tag minimization messages. */
     "%s end-tag found;",
     "Short (no GI) %s end-tag found;",
     "NET delimiter %s end-tag found;",
     "Data tag %s end-tag found;"
};
UNCH *genext[] = {            /* Generated external entity file types. */
     /* Dummy    */  NULL,    /* Dummy entry to use zero position in array.*/
     /* 6*0*1    */  ".NSD",  /* Non-SGML data entity. */
     /* 6*0*2    */  ".GML",  /* GML document or text entity. */
     /* 6*0*3    */  ".SPE",  /* System parameter entity. */
     /* 6*0*4    */  ".DTD",  /* Document type definition. */
     /* 6*0*5    */  ".LPD",  /* Link process definition. */
     /* 6*0*6    */  ".DCN",  /* Data content notation. */
     /* 6*1*1    */  ".PNS",  /* Public non-SGML data entity. */
     /* 6*1*2    */  ".PGE",  /* Public general entity. */
     /* 6*1*3    */  ".PPE",  /* Public parameter entity. */
     /* 6*1*4    */  ".PDT",  /* Public document type definition. */
     /* 6*1*5    */  ".PLP",  /* Public link process definition. */
     /* 6*1*6    */  ".PCN",  /* Public data content notation. */
     /* 6*2*1    */  ".VNS",  /* Display version non-SGML data entity. */
     /* 6*2*2    */  ".VGE",  /* Display version general entity. */
     /* 6*2*3    */  ".VPE",  /* Display version parameter entity. */
     /* 6*2*4    */  ".VDT",  /* Display version document type definition.*/
     /* 6*2*5    */  ".VLP",  /* Display version link process definition.*/
     /* 6*2*6    */  ".PCN"   /* ***** CANNOT OCCUR ****                */
};
UNCH *realmsg[] =             /* Real tag portion of minimization messages.*/
     {"short (no GI)", "data", "short (no GI)", "NET delimiter"};
UNCH *msgfptr = "SGML.MSG";   /* Pointer to SGML message file id. */
UNCH options[] =              /* Text for invalid option error message. */
     "/c10 /d /e /f /g /mSGML.MSG /p1 /r /s /t3";
/******************************************************************************/
/* Conditional inclusions
*/
#ifdef V2
UNCH *formats[] = {           /* Formatting procedures for chainsaw sculpture.*/
    NULL,                     /* Dummy: to synchronize subscripts. */
    "P",                      /* FORMATP: Phrase */
    "B",                      /* FORMATB: Block */
    "S",                      /* FORMATS: Structure */
    "N"                       /* FORMATN: Non-SGML data */
};
#endif
/******************************************************************************/
