/******************************************************************************/
/* TOOLS.H: Definitions for type declarations, printing, bit handling, etc.
*/
typedef void *UNIV;           /* Universal (i.e., undefined) pointer type. */
typedef char *STRING;         /* String data type. */
typedef char UNCH;            /* All characters are unsigned. */
typedef unsigned UNS;         /* Simplifies changing int to unsigned. */

#define VOID void             /* For compilers that don't support void yet. */
#define FILESPEC 2+64+1+8+4+(2)  /* DOS: Maximum length of a file id + (2). */
#define ZAPEOL(cc) ((cc!=0&&cc!=9&&cc!=10&&cc!=13&&cc!=26&&cc!=28) ? cc : 168)

/* Macros for bit manipulation.
*/
#define SET(word, bits)          ((word) |= (bits))    /* Turn bits on */
#define RESET(word, bits)        ((word) &= ~(bits))   /* Turn bits off */
#define GET(word, bits)          ((word) & (bits))     /* 1=any bit on */
#define BITOFF(word, bits)       (GET(word, bits)==0)  /* 1=no bits on */
#define BITON(word, bits)        ((word) & (bits))     /* 1=any bit on */
#define BITNON(bits,n) ((bits) |= 1L<<((n)-1)) /* Turn on the nth bit. */
#define BITNIS(bits,n) (BITON((bits),(1L<<((n)-1))))/* Test the nth bit. */

/* Pointers (should work for big memory model).
*/
#define MINPTR   ((struct etd *)10)/* Minimum value for real pointer. */
#define ETDCDATA ((struct etd *)1) /* Dummy etd pointer for #PCDATA. */
#define ETDNULL  ((struct etd *)2) /* Dummy etd pointer for null tag. */
#define ETDNET   ((struct etd *)3) /* Dummy etd pointer for NET delimiter. */
#define STRNULL  ((UNCH *)2)       /* Dummy pointer for null string. */

#define ITOAMAX 3             /* Max digits that itoa() can handle. */
/******************************************************************************/
