/******************************************************************************/
#include "vmincl.h"           /* Include files for VM. */
#include "vmxtrn.h"           /* Declarations for VM public variables. */
/******************************************************************************/
/* SGMLMEM: Support environment memory services for SGML.
            TO DO: Add subpool allocation to support SUBDOC
                   and the use of a variant concrete syntax
                   in document instances together with the
                   reference concrete syntax in the prologs.
*/
void sgmlmem(im)
struct ipbmem *im;            /* IPB: memory services. */
{
     switch (im->memtype) {
     case MEMGET:             /* Get memory area of specified size. */
          im->memarea = calloc(im->memsize, 1);
          return;
     case MEMFREE:            /* Free designated memory area. */
          free(im->memarea);
          return;
     }
}
/******************************************************************************/
/* Memory functions for the interface and text processor.  If desired, these
   can be modified to call SGMLMEM so that all memory will be allocated by
   the same routine.
*/
/******************************************************************************/
/* SAVESTR: Save a string whose length is in its first byte.
            The string is saved with the length byte.
*/
UNCH *savestr(s)
UNCH *s;
{
     UNCH *rp;

     rp = vmalloc((UNS)*s);        /* Allocate storage for string. */
     memcpy(rp, s, *s);            /* Copy string into new storage. */
     return rp;                    /* Return pointer to stored string. */
}
/******************************************************************************/
/* VMALLOC: Interface to memory allocation with error handling.
            If storage is not available, fatal error message is issued.
            Storage is initialized to zeros.
*/
UNCH *vmalloc(size)
unsigned size;                /* Number of bytes of initialized storage. */
{
	UNCH *ptr;

	if ((ptr = calloc(size, 1))!=NULL) return ptr;
	printf(
"\nVM201-> ***** Out of memory; processing ended. *****"
	);
	exit(201);
	/*lint -unreachable         There is no implied return at this point. */
	return 0;                /* Avoid Borland C++ warning. */
}
/******************************************************************************/
