/*****************************************************************************/
/* SGMLAPI: SGML API for C                                                   */
/* Author: Charles F. Goldfarb                                               */
/******************************************************************************/
#include "sgmlapi.h"          /* Text processor header for SGML interfacing. */
#include "vmincl.h"           /* Include files for VM. */
#include "vmxtrn.h"           /* Declarations for VM public variables. */
/******************************************************************************/
struct rcbde de = {0};        /* RCB for current data entity information. */
struct rcbte te = {0};        /* RCB for calls to SGMLAPI (TP+ENV). */
UNCH sgmlomsg[] =             /* Text for invalid option error message. */
     "/d /e /f /g /mSGML.MSG /p1 /r /t3";
/******************************************************************************/
/* Secret public variable for use by markup validator (not in SGMLAPI.H). */
int TPisVM = 0;               /* Set to 1 by TP if it is markup validator. */
/******************************************************************************/
void alset(struct ad *);      /* Set up to start processing att list. */
void setndata(PNE);           /* Build ext data entity rcbde with entity text.*/
/******************************************************************************/
/* SGMLNEXT: Get the next RCB from SGML and transfer data to local variables.
*/
int sgmlnext(void)
{
     loop:
     sgml((struct ipbt *)0);
     if (!suppsw)
          getscbs(SGMLSCBS, SGMLES);
     switch (RCBTYPE) {
     case SGMLDAF:            /* Data found. */
          if (suppsw) goto loop;
          te.datalen = CDATALEN;
          te.data = CDATA;
          if (CDESW) return (TPCDATA);
          /* else */ if (SDESW) return (TPSDATA);
          /* else */ if (NDESW) {setndata(NEPTR); return(TPNDATA);}
          /* else */ if (*te.data==tpsw.delnonch) {
               te.nonsgml = te.data[1]-tpsw.addnonch;
               return(TPNSGML);
          }
          /* else */ return(TPPCDATA);

     case SGMLSTG:            /* Start-tag found. */
          memcpy( &tptags[++tpts][0] , GI, (UNS)*(GI-1) ); /* Stack the GI. */
          if (suppsw) goto loop;
          te.data = GI;
          te.datalen = *(GI-1)-2;
          te.gidata = GIDATA;
#ifdef V2
          te.format = FORMAT;
#endif
          if (ALPTR) {             /* Tag attributes will be processed. */
               alptr = ALPTR;      /* Tag attributes are active att list. */
               te.alcnt = AN;      /* Indicate number of attributes in list. */
               te.pca = &te.ca;    /* Current attribute structure in rcbte. */
               alset((struct ad *)0); /* Initialize for alnext processing. */
          }
          else te.alcnt = 0;
          return(TPSTAG);

     case SGMLETG:            /* End-tag found. */
          --tpts;             /* Destack the GI. */
          if (suppsw) goto loop;
          te.data = GI;
          te.datalen = *(GI-1)-2;
          te.gidata = GIDATA;
#ifdef V2
          te.format = FORMAT;
#endif
          return(TPETAG);

     case SGMLPIS:            /* Processing instruction: string. */
          if (suppsw) goto loop;
          te.datalen = PDATALEN;
          te.data = PDATA;
          return(PIESW ? TPPIENT : TPPI);

     case SGMLREF:            /* Record end found. */
          if (suppsw) goto loop;
          return(TPRE);

     case SGMLSDTD:           /* Document type definition started. */
          eltrsw = 0;         /* Suppress GI stack trace in messages. */
          if (!TPisVM || suppsw) goto loop;
          te.datalen = DTYPELEN-2;
          te.data = DOCTYPE+1;
          return(TPSDTD);

     case SGMLEDTD:           /* Document type definition completed. */
          eltrsw = eltrsv;    /* Restore GI stack trace in messages. */
          if (suppsw) goto loop;
          te.datalen = DTYPELEN-2;
          te.data = DOCTYPE+1;
          return(TPEDTD);

     case SGMLMV:             /* Markup validator information. */
          if (!TPisVM) goto loop;
          /* else */ return(TPMV);

     case SGMLEOD:            /* End of document. */
          return(TPEOD);
     }
     return(TPEOD);           /* Avoid lint and TurboC warnings. */
}
/******************************************************************************/
#include "sgmlsubs.c"         /* Subroutines for SGML API. */
/******************************************************************************/
