/******************************************************************************/
/* ERROR.H: Symbols for SGML error codes (start with '_').
            Numbers 46 - 56 are generated by ERROR.C.
            Later numbers are coded directly.
*/
/* SGMLERR.C: General errors and syntax errors.
*/
#define _CONTEXT   1   /* W  GI not allowed at this point in structure. */
#define _MDNAME    2   /* E  Invalid markup declaration name. */
/*efine _LEN       3   /* E  Syntax error: length exceeded. */
#define _SYS       4   /* W  Illegal system character. */
#define _ETAG      5   /* E  End-tag does not match any open start-tag. */
#define _STAGMAX   6   /* E  Maximum number of open elements exceeded. */
/*      _ALLNULL   7   /* W  Start- and end-tag omitted with null content. */
#define _EOF       8   /* E/W Illegal entity end in markup or delimited text. */
/* fine _INV       9   /* E  Markup error: invalid character. */
#define _CHARS    10   /* W  Data found in content that doesn't allow it. */
/* fine _NOETDE   11   /* E  End-tag GI not defined by element declaration. */
#define _BADNM    12   /* E  Name is not syntactically valid. */
#define _BADATT   13   /* E  Attribute was not defined by element declaration. */
#define _VALINV   14   /* W  Att value/declaration conflict: invalid char. */
#define _VALLEN   15   /* W  Att value/declaration conflict: token too long. */
#define _VALCNT   16   /* W  Att value/declaration conflict: too many tokens. */
#define _VALTYPE  17   /* W  Att value/declaration conflict: wrong token type.*/
#define _VALGRP   18   /* W  Att value/declaration conflict: token not in grp.*/
#define _VALREQ   19   /* W  Att value/declaration conflict: req unspecified. */
/*      _EMIN     20   /* W  End-tag implied by end-tag; not minimizable. */
/*      _SMIN     21   /* W  Omitted start-tag was not minimizable. */
#define _POSSATT  22   /* E  Possible att found but not defined; used as data.*/
/* Late additions numbered out of order to avoid recompilation. */
/*efine _ENTSYNC  37   /* E  Entity and group nesting levels out of sync. */
#define _BADVAL   25   /* W  Att value omitted (null); default used. */
/*      _ECONTXT  30   /* W  Element ended prematurely (some content omitted).*/
/*      _EMINST   39   /* W  End-tag implied by start-tag; not minimizable. */
/*      _MEXTAG   40   /* W  *** In Use ***                               */
#define _MEXERR   41   /* W  Attempt to exclude contextually required element.*/
#define _DOCTYPE  42   /* W  No document type defined; *DOCTYPE assumed. */
/*      _NOETDS   43   /* E  Start-tag GI not defined by element declaration. */
#define _RESTART  44   /* E  Invalid chars ignored; trying to restart parse. */

/* MDERROR.C: Errors in markup declarations.
*/
/*efine _DUP      23   /* E  Duplicate specification. */
/*efine _KEY      24   /* E  Incorrect keyword for parameter. */
/*efine _MSE      26   /* E  MSE occurred with no corresponding MS. */
/*efine _MSS      27   /* E  MSS exceeded maximum nesting level. */
/*efine _NUM      28   /* E  Incorrect number of parameters. */
#define _TYPE     29   /* E  Incorrect parameter type. */
/* Late additions numbered out of order to avoid recompilation. */
/*efine _VAL      38   /* W  Incorrect parameter value. */

/* RESERROR.C: Errors in resource routines.
*/
/* Unused                 I  End of primary source entity. */
/* fine _FILBUF   31   /* E  Could not read next buffer. */
/* fine _ERFILE   32   /* E  Could not open file. */
/* fine _MALLOC   33   /* T  Could not obtain required main storage. */
/* fine _ERMAX    34   /* E  Maximum number of open entities exceeded. */
/* fine _ERNAME   35   /* E  Referenced entity undeclared. */
/* fine _ERLOOP   36   /* E  Entity referenced within itself: ref ignored. */
/* Late additions numbered out of order to avoid recompilation. */
/*      _ERDEF    45   /* E  Referenced entity undeclared; SYSTEM assumed. */
/******************************************************************************/
