/******************************************************************************/
/* ENVCB.H: Control blocks used by text processor environment.
*/
/******************************************************************************/
typedef int HANDLE;           /* Low-level I/O: handle is integer. */
/******************************************************************************/
struct iofcb {                /* I/O file control block. */
     HANDLE fcbfd;            /* DOS file handle. */
     long fcboff;             /* Offset in file of current read block. */
     char *fcbxid;            /* External ID string. */
     char *fcbnext;           /* Next file in fcbxid (NULL if no more). */
     char fcbfile[FILESPEC+2];/* Full system fileid (length + EOS). */
     int fcbcatsw;            /* 1=catenate next file on next read; 0=no. */
     int fcbRS;               /* 1=prefix RS to first file of entity; 0=no. */
     int fcbRE;               /* 1=strip RE from last file of entity; 0=no. */
     int fcbfirst;            /* 1=next read will be the first; 0=no. */
};
#define IPBFCB ((struct iofcb *)io->ipbn)      /* IPBFILE: Ptr to SGMLIO fcb. */
#define FLID (((struct iofcb *)SCBFCB)->fcbfile)/* Actual fileid of file. */
/******************************************************************************/
